/*
 * Decompiled with CFR 0.152.
 */
package org.veiset.kgame.engine.ecs.core.system.graphics;

import com.badlogic.ashley.core.Engine;
import com.badlogic.ashley.core.Entity;
import com.badlogic.ashley.core.EntitySystem;
import com.badlogic.ashley.core.Family;
import com.badlogic.ashley.utils.ImmutableArray;
import com.badlogic.gdx.graphics.OrthographicCamera;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.math.Vector3;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.veiset.kgame.engine.GameFilesKt;
import org.veiset.kgame.engine.TBEngineKt;
import org.veiset.kgame.engine.ecs.core.component.PositionComponent;
import org.veiset.kgame.engine.ecs.core.component.camera.CameraEffectComponent;
import org.veiset.kgame.engine.ecs.core.component.camera.CameraFollowComponent;
import org.veiset.kgame.engine.ecs.core.component.camera.CameraManipulation;
import org.veiset.kgame.engine.ecs.core.component.camera.CameraMovementI;
import org.veiset.kgame.engine.ecs.core.component.camera.CameraShake;
import org.veiset.kgame.engine.ecs.core.component.camera.CameraZoomI;
import org.veiset.kgame.engine.ecs.core.component.player.PlayerCharacterComponent;
import org.veiset.kgame.engine.ecs.core.system.Mapper;
import org.veiset.kgame.engine.ecs.core.system.MapperNullable;
import org.veiset.kgame.engine.math.Vector2Kt;
import org.veiset.kgame.engine.world.WorldMapBounds;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0018B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0017H\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/veiset/kgame/engine/ecs/core/system/graphics/CameraSystem;", "Lcom/badlogic/ashley/core/EntitySystem;", "initPos", "Lcom/badlogic/gdx/math/Vector2;", "worldMapBounds", "Lorg/veiset/kgame/engine/world/WorldMapBounds;", "(Lcom/badlogic/gdx/math/Vector2;Lorg/veiset/kgame/engine/world/WorldMapBounds;)V", "camera", "Lcom/badlogic/gdx/graphics/OrthographicCamera;", "cameraFollowEntities", "Lcom/badlogic/ashley/utils/ImmutableArray;", "Lcom/badlogic/ashley/core/Entity;", "cameraHandler", "Lorg/veiset/kgame/engine/ecs/core/system/graphics/CameraSystem$CameraHandler;", "cameraMovements", "playerCharacter", "virtualCamera", "addedToEngine", "", "engine", "Lcom/badlogic/ashley/core/Engine;", "update", "delta", "", "CameraHandler", "kgame2"})
public final class CameraSystem
extends EntitySystem {
    @NotNull
    private final WorldMapBounds worldMapBounds;
    @NotNull
    private final CameraHandler cameraHandler;
    @NotNull
    private final OrthographicCamera virtualCamera;
    @NotNull
    private final OrthographicCamera camera;
    private ImmutableArray<Entity> cameraFollowEntities;
    private ImmutableArray<Entity> cameraMovements;
    private ImmutableArray<Entity> playerCharacter;

    /*
     * WARNING - void declaration
     */
    public CameraSystem(@NotNull Vector2 initPos, @NotNull WorldMapBounds worldMapBounds) {
        void it;
        OrthographicCamera orthographicCamera;
        Intrinsics.checkNotNullParameter(initPos, "initPos");
        Intrinsics.checkNotNullParameter(worldMapBounds, "worldMapBounds");
        this.worldMapBounds = worldMapBounds;
        this.cameraHandler = new CameraHandler();
        OrthographicCamera orthographicCamera2 = orthographicCamera = new OrthographicCamera(1920.0f, 1080.0f);
        CameraSystem cameraSystem = this;
        boolean bl = false;
        it.setToOrtho(false, 1920.0f, 1080.0f);
        cameraSystem.virtualCamera = orthographicCamera;
        this.camera = TBEngineKt.getGlobals().getDrawGfx().getCamera();
        this.virtualCamera.position.set(Vector2Kt.dw(initPos), 0.0f);
        TBEngineKt.getGlobals().updateDrawMatrix();
    }

    @Override
    public void addedToEngine(@NotNull Engine engine) {
        Intrinsics.checkNotNullParameter(engine, "engine");
        Class[] classArray = new Class[]{PositionComponent.class, CameraFollowComponent.class};
        ImmutableArray<Entity> immutableArray = engine.getEntitiesFor(Family.all(classArray).get());
        Intrinsics.checkNotNullExpressionValue(immutableArray, "engine.getEntitiesFor(Fa\u2026onent::class.java).get())");
        this.cameraFollowEntities = immutableArray;
        classArray = new Class[]{CameraEffectComponent.class};
        immutableArray = engine.getEntitiesFor(Family.all(classArray).get());
        Intrinsics.checkNotNullExpressionValue(immutableArray, "engine.getEntitiesFor(Fa\u2026onent::class.java).get())");
        this.cameraMovements = immutableArray;
        classArray = new Class[]{PlayerCharacterComponent.class};
        immutableArray = engine.getEntitiesFor(Family.all(classArray).get());
        Intrinsics.checkNotNullExpressionValue(immutableArray, "engine.getEntitiesFor(Fa\u2026onent::class.java).get())");
        this.playerCharacter = immutableArray;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void update(float delta) {
        void $this$mapTo$iv$iv;
        Entity cameraFollowEntity;
        ImmutableArray<Entity> immutableArray = this.cameraFollowEntities;
        if (immutableArray == null) {
            Intrinsics.throwUninitializedPropertyAccessException("cameraFollowEntities");
            immutableArray = null;
        }
        if ((cameraFollowEntity = (Entity)CollectionsKt.firstOrNull((Iterable)immutableArray)) == null) {
            ImmutableArray<Entity> immutableArray2 = this.playerCharacter;
            if (immutableArray2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("playerCharacter");
                immutableArray2 = null;
            }
            Entity entity = (Entity)CollectionsKt.firstOrNull((Iterable)immutableArray2);
            if ((entity == null ? null : entity.add(new CameraFollowComponent(0.0f, 0.0f, 0.0f, 0.0f, 15, null))) == null) {
                return;
            }
            return;
        }
        Vector2 targetPos = Mapper.INSTANCE.getPosition().get(cameraFollowEntity).getPos();
        CameraFollowComponent cameraFollow = Mapper.INSTANCE.getCameraFollow().get(cameraFollowEntity);
        Vector3 vector3 = this.virtualCamera.position;
        Intrinsics.checkNotNullExpressionValue(vector3, "virtualCamera.position");
        Vector2 cameraPos = Vector2Kt.gfxToWorld(Vector2Kt.v2(vector3));
        Vector2 dstVector = Vector2Kt.minus(targetPos, cameraPos);
        ImmutableArray<Entity> immutableArray3 = this.cameraMovements;
        if (immutableArray3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("cameraMovements");
            immutableArray3 = null;
        }
        Iterable $this$map$iv = immutableArray3;
        boolean $i$f$map = false;
        Object object = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void entity;
            CameraEffectComponent cameraEffectComponent;
            Entity entity2 = (Entity)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            CameraEffectComponent it = cameraEffectComponent = Mapper.INSTANCE.getCameraEffect().get((Entity)entity);
            boolean bl2 = false;
            CameraManipulation cameraManipulation = it.getCameraMovement();
            cameraManipulation.setElapsed(cameraManipulation.getElapsed() + delta);
            if (it.getCameraMovement().getElapsed() >= it.getCameraMovement().getDuration()) {
                this.getEngine().removeEntity((Entity)entity);
            }
            collection.add(cameraEffectComponent);
        }
        List cameraEffectComponents = (List)destination$iv$iv;
        float dst = dstVector.len();
        if (dst > cameraFollow.getMaxDistance() * 1.01f) {
            Vector2 maxTarget = Vector2Kt.minus(targetPos, cameraPos).nor().scl(cameraFollow.getMaxDistance());
            Intrinsics.checkNotNullExpressionValue(maxTarget, "maxTarget");
            Vector2 newTarget = Vector2Kt.minus(targetPos, maxTarget);
            this.virtualCamera.position.set(Vector2Kt.dw(newTarget), 0.0f);
        } else if (dst >= cameraFollow.getSoftMaxDistance()) {
            object = dstVector.nor().scl(cameraFollow.getMaxSpeed() * 3.0f * delta * (float)60);
            Intrinsics.checkNotNullExpressionValue(object, "dstVector.nor().scl(came\u2026xSpeed * 3f * delta * 60)");
            Vector2 dw = Vector2Kt.dw((Vector2)object);
            this.virtualCamera.translate(dw);
        } else if (dst >= cameraFollow.getNoFollow()) {
            object = dstVector.nor().scl(cameraFollow.getMaxSpeed() * delta * (float)60);
            Intrinsics.checkNotNullExpressionValue(object, "dstVector.nor().scl(came\u2026ow.maxSpeed * delta * 60)");
            Vector2 dw = Vector2Kt.dw((Vector2)object);
            this.virtualCamera.translate(dw);
        }
        object = this.virtualCamera.position;
        Intrinsics.checkNotNullExpressionValue(object, "virtualCamera.position");
        Vector2 campos = Vector2Kt.gfxToWorld(Vector2Kt.v2((Vector3)object));
        object = this.worldMapBounds.keepBound(campos, this.camera.zoom);
        float camx = Vector2Kt.component1((Vector2)object);
        float camy = Vector2Kt.component2((Vector2)object);
        this.virtualCamera.position.x = camx * 120.0f;
        this.virtualCamera.position.y = camy * 120.0f;
        if (MapperNullable.INSTANCE.getPlayer().get(cameraFollowEntity) != null) {
            // empty if block
        }
        this.camera.position.set(this.virtualCamera.position);
        this.cameraHandler.update(delta, cameraEffectComponents);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/veiset/kgame/engine/ecs/core/system/graphics/CameraSystem$CameraHandler;", "", "()V", "camera", "Lcom/badlogic/gdx/graphics/OrthographicCamera;", "update", "", "delta", "", "targets", "", "Lorg/veiset/kgame/engine/ecs/core/component/camera/CameraEffectComponent;", "kgame2"})
    public static final class CameraHandler {
        @NotNull
        private final OrthographicCamera camera = TBEngineKt.getGlobals().getDrawGfx().getCamera();

        /*
         * WARNING - void declaration
         */
        public final void update(float delta, @NotNull List<CameraEffectComponent> targets) {
            Vector3 vector3;
            void $this$filterIsInstanceTo$iv$iv3;
            void $this$filterIsInstance$iv;
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv;
            void $this$fold$iv;
            void $this$filterIsInstanceTo$iv$iv2;
            Iterable $this$filterIsInstance$iv2;
            Collection collection;
            void $this$mapTo$iv$iv2;
            Iterable $this$map$iv2;
            List list;
            Collection destination$iv$iv;
            Intrinsics.checkNotNullParameter(targets, "targets");
            if (!GameFilesKt.getGameConfig().getEffectScreenShake()) {
                void $this$filterTo$iv$iv;
                Iterable $this$filter$iv = targets;
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    CameraEffectComponent it = (CameraEffectComponent)element$iv$iv;
                    boolean bl = false;
                    if (!(!(it.getCameraMovement() instanceof CameraShake))) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                list = (List)destination$iv$iv;
            } else {
                list = targets;
            }
            List effects = list;
            Iterable $i$f$filter = effects;
            boolean $i$f$map = false;
            destination$iv$iv = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv2, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                void it;
                CameraEffectComponent bl = (CameraEffectComponent)item$iv$iv;
                collection = destination$iv$iv2;
                boolean bl2 = false;
                collection.add(it.getCameraMovement());
            }
            $this$map$iv2 = (List)destination$iv$iv2;
            boolean $i$f$filterIsInstance = false;
            $this$mapTo$iv$iv2 = $this$filterIsInstance$iv2;
            destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv2) {
                if (!(element$iv$iv instanceof CameraMovementI)) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            $this$filterIsInstance$iv2 = (List)destination$iv$iv2;
            Object initial$iv = new Vector2(0.0f, 0.0f);
            boolean $i$f$fold = false;
            Vector2 accumulator$iv = initial$iv;
            for (Object element$iv : $this$fold$iv) {
                void vm;
                Object element$iv$iv;
                element$iv$iv = (CameraMovementI)element$iv;
                Vector2 acc = accumulator$iv;
                boolean bl = false;
                accumulator$iv = Vector2Kt.plus(acc, vm.offset(delta));
            }
            Vector2 movements = accumulator$iv;
            initial$iv = effects;
            boolean $i$f$map2 = false;
            accumulator$iv = $this$map$iv;
            Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                CameraEffectComponent bl = (CameraEffectComponent)item$iv$iv;
                collection = destination$iv$iv3;
                boolean bl3 = false;
                collection.add(it.getCameraMovement());
            }
            $this$map$iv = (List)destination$iv$iv3;
            boolean $i$f$filterIsInstance22 = false;
            $this$mapTo$iv$iv = $this$filterIsInstance$iv;
            destination$iv$iv3 = new ArrayList();
            boolean $i$f$filterIsInstanceTo2 = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv3) {
                if (!(element$iv$iv instanceof CameraZoomI)) continue;
                destination$iv$iv3.add(element$iv$iv);
            }
            List zooms = (List)destination$iv$iv3;
            if (!((Collection)zooms).isEmpty()) {
                float zoom;
                void $this$fold$iv2;
                void initial$iv2;
                Iterable $i$f$filterIsInstance22 = zooms;
                float $this$filterIsInstanceTo$iv$iv3 = 0.0f;
                float f = 1.0f;
                boolean $i$f$fold2 = false;
                void accumulator$iv2 = initial$iv2;
                for (Object element$iv : $this$fold$iv2) {
                    void cameraZoom;
                    CameraZoomI it = (CameraZoomI)element$iv;
                    void acc = accumulator$iv2;
                    boolean bl = false;
                    accumulator$iv2 = acc + cameraZoom.zoom(delta);
                }
                void var17_40 = accumulator$iv2;
                this.camera.zoom = zoom = f + var17_40;
            }
            Vector3 vector32 = vector3 = this.camera.position;
            Intrinsics.checkNotNullExpressionValue(vector3, "camera.position");
            vector32.set(Vector2Kt.plus(Vector2Kt.v2(vector3), Vector2Kt.dw(movements)), 0.0f);
            TBEngineKt.getGlobals().updateDrawMatrix();
        }
    }
}

