/*
 * Decompiled with CFR 0.152.
 */
package org.veiset.kgame.engine.ecs.core.system.graphics;

import box2dLight.RayHandler;
import com.badlogic.ashley.core.Engine;
import com.badlogic.ashley.core.EntityListener;
import com.badlogic.ashley.core.EntitySystem;
import com.badlogic.ashley.core.Family;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.physics.box2d.World;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.veiset.kgame.engine.GameFilesKt;
import org.veiset.kgame.engine.TBEngineKt;
import org.veiset.kgame.engine.ecs.core.component.draw.LightFollowComponent;
import org.veiset.kgame.engine.ecs.core.component.draw.LightStaticComponent;
import org.veiset.kgame.engine.ecs.core.system.debug.ProfilerSystemKt;
import org.veiset.kgame.engine.ecs.core.system.graphics.ShadowSystemKt;
import org.veiset.kgame.engine.ecs.event.LightListener;
import org.veiset.kgame.engine.values.ProfilerName;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0010"}, d2={"Lorg/veiset/kgame/engine/ecs/core/system/graphics/LightSystem;", "Lcom/badlogic/ashley/core/EntitySystem;", "world", "Lcom/badlogic/gdx/physics/box2d/World;", "(Lcom/badlogic/gdx/physics/box2d/World;)V", "rayHandler", "Lbox2dLight/RayHandler;", "getWorld", "()Lcom/badlogic/gdx/physics/box2d/World;", "addedToEngine", "", "engine", "Lcom/badlogic/ashley/core/Engine;", "update", "deltaTime", "", "kgame2"})
public final class LightSystem
extends EntitySystem {
    @NotNull
    private final World world;
    @NotNull
    private final RayHandler rayHandler;

    public LightSystem(@NotNull World world) {
        Intrinsics.checkNotNullParameter(world, "world");
        this.world = world;
        this.rayHandler = new RayHandler(this.world);
        RayHandler.useDiffuseLight(true);
        float fl = 0.3f;
        this.rayHandler.setAmbientLight(fl, fl, fl, 0.2f);
        this.rayHandler.setBlurNum(6);
        this.rayHandler.setShadows(true);
    }

    @NotNull
    public final World getWorld() {
        return this.world;
    }

    @Override
    public void addedToEngine(@NotNull Engine engine) {
        Intrinsics.checkNotNullParameter(engine, "engine");
        Class[] classArray = new Class[]{LightFollowComponent.class, LightStaticComponent.class};
        engine.addEntityListener(Family.one(classArray).get(), (EntityListener)new LightListener(this.rayHandler));
    }

    @Override
    public void update(float deltaTime) {
        if (Gdx.input.isKeyJustPressed(40)) {
            GameFilesKt.getGameConfig().setEffectLight(!GameFilesKt.getGameConfig().getEffectLight());
        }
        if (!GameFilesKt.getGameConfig().getEffectLight()) {
            return;
        }
        Engine engine = this.getEngine();
        Intrinsics.checkNotNullExpressionValue(engine, "engine");
        ProfilerSystemKt.profile(engine, ProfilerName.LIGHT, (Function0)new Function0<Unit>(this){
            final /* synthetic */ LightSystem this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                ShadowSystemKt.viewportUpdate(LightSystem.access$getRayHandler$p(this.this$0));
                TBEngineKt.getGlobals().updateDrawMatrix();
            }
        });
    }

    public static final /* synthetic */ RayHandler access$getRayHandler$p(LightSystem $this) {
        return $this.rayHandler;
    }
}

