/*
 * Decompiled with CFR 0.152.
 */
package org.veiset.kgame.engine.ecs.core.system.levelselect;

import com.badlogic.ashley.core.ComponentMapper;
import com.badlogic.ashley.core.Engine;
import com.badlogic.ashley.core.Entity;
import com.badlogic.ashley.core.EntitySystem;
import com.badlogic.ashley.core.Family;
import com.badlogic.ashley.utils.ImmutableArray;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.graphics.glutils.ShapeRenderer;
import com.badlogic.gdx.math.Vector2;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import ktx.graphics.ColorKt;
import org.jetbrains.annotations.NotNull;
import org.veiset.kgame.engine.Log;
import org.veiset.kgame.engine.TBEngineKt;
import org.veiset.kgame.engine.asset.AssetManager;
import org.veiset.kgame.engine.asset.AssetRef;
import org.veiset.kgame.engine.ecs.core.component.PositionComponent;
import org.veiset.kgame.engine.ecs.core.component.levelselect.GameLevelComponent;
import org.veiset.kgame.engine.ecs.core.entity.levelselect.SelectedLevelComponent;
import org.veiset.kgame.engine.ecs.core.system.Mapper;
import org.veiset.kgame.engine.math.Hex;
import org.veiset.kgame.engine.math.HexLayout;
import org.veiset.kgame.engine.math.Vector2Kt;
import org.veiset.kgame.engine.tools.ui.UiComponentsKt;
import org.veiset.kgame.engine.util.GdxUtilsKt;
import org.veiset.kgame.engine.values.Asset;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/veiset/kgame/engine/ecs/core/system/levelselect/DrawHexSystem;", "Lcom/badlogic/ashley/core/EntitySystem;", "hexLayout", "Lorg/veiset/kgame/engine/math/HexLayout;", "(Lorg/veiset/kgame/engine/math/HexLayout;)V", "am", "Lorg/veiset/kgame/engine/asset/AssetManager;", "getHexLayout", "()Lorg/veiset/kgame/engine/math/HexLayout;", "hexes", "Lcom/badlogic/ashley/utils/ImmutableArray;", "Lcom/badlogic/ashley/core/Entity;", "selectState", "addedToEngine", "", "engine", "Lcom/badlogic/ashley/core/Engine;", "update", "deltaTime", "", "kgame2"})
public final class DrawHexSystem
extends EntitySystem {
    @NotNull
    private final HexLayout hexLayout;
    @NotNull
    private final AssetManager am;
    private ImmutableArray<Entity> hexes;
    private ImmutableArray<Entity> selectState;

    public DrawHexSystem(@NotNull HexLayout hexLayout) {
        Intrinsics.checkNotNullParameter(hexLayout, "hexLayout");
        this.hexLayout = hexLayout;
        this.am = TBEngineKt.getGlobals().getAssetManager();
    }

    @NotNull
    public final HexLayout getHexLayout() {
        return this.hexLayout;
    }

    @Override
    public void addedToEngine(@NotNull Engine engine) {
        Intrinsics.checkNotNullParameter(engine, "engine");
        Class[] classArray = new Class[]{GameLevelComponent.class, PositionComponent.class};
        ImmutableArray<Entity> immutableArray = engine.getEntitiesFor(Family.all(classArray).get());
        Intrinsics.checkNotNullExpressionValue(immutableArray, "engine.getEntitiesFor(Fa\u2026onent::class.java).get())");
        this.hexes = immutableArray;
        classArray = new Class[]{SelectedLevelComponent.class};
        immutableArray = engine.getEntitiesFor(Family.all(classArray).get());
        Intrinsics.checkNotNullExpressionValue(immutableArray, "engine.getEntitiesFor(Fa\u2026onent::class.java).get())");
        this.selectState = immutableArray;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void update(float deltaTime) {
        void $this$forEach$iv;
        Iterator $this$filterTo$iv$iv;
        Object item$iv$iv2;
        void $this$mapTo$iv$iv;
        Gdx.gl.glEnable(3042);
        Gdx.gl.glBlendFunc(770, 771);
        UiComponentsKt.getSpriteBatch().begin();
        ComponentMapper<SelectedLevelComponent> componentMapper = Mapper.LevelSelect.INSTANCE.getSelectLevel();
        ImmutableArray<Entity> immutableArray = this.selectState;
        if (immutableArray == null) {
            Intrinsics.throwUninitializedPropertyAccessException("selectState");
            immutableArray = null;
        }
        SelectedLevelComponent selectLevel = componentMapper.get(immutableArray.first());
        GameLevelComponent selectedLevel = selectLevel.getSelected();
        GameLevelComponent hoveredLevel = selectLevel.getHovered();
        ImmutableArray<Entity> immutableArray2 = this.hexes;
        if (immutableArray2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("hexes");
            immutableArray2 = null;
        }
        Iterable $this$map$iv = immutableArray2;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv2 : $this$mapTo$iv$iv) {
            void it;
            Entity entity = (Entity)item$iv$iv2;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(Mapper.LevelSelect.INSTANCE.getGameLevel().get((Entity)it));
        }
        List levels = (List)destination$iv$iv;
        Iterable $this$filter$iv = levels;
        boolean $i$f$filter = false;
        destination$iv$iv = $this$filter$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo = false;
        item$iv$iv2 = $this$filterTo$iv$iv.iterator();
        while (item$iv$iv2.hasNext()) {
            Object element$iv$iv = item$iv$iv2.next();
            GameLevelComponent it = (GameLevelComponent)element$iv$iv;
            boolean bl2 = false;
            if (!it.getFinished()) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        int clearedMaps = ((List)destination$iv$iv2).size();
        ImmutableArray<Entity> immutableArray3 = this.hexes;
        if (immutableArray3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("hexes");
            immutableArray3 = null;
        }
        Iterable $this$sortedByDescending$iv = immutableArray3;
        boolean $i$f$sortedByDescending = false;
        $this$sortedByDescending$iv = CollectionsKt.sortedWith($this$sortedByDescending$iv, new Comparator(){

            public final int compare(T a, T b) {
                Entity it = (Entity)b;
                boolean bl = false;
                it = (Entity)a;
                Comparable comparable = Float.valueOf(Mapper.INSTANCE.getPosition().get((Entity)it).getPos().y);
                bl = false;
                return ComparisonsKt.compareValues(comparable, (Comparable)Float.valueOf(Mapper.INSTANCE.getPosition().get((Entity)it).getPos().y));
            }
        });
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Entity entity = (Entity)element$iv;
            boolean bl = false;
            Vector2 position = Mapper.INSTANCE.getPosition().get(entity).getPos();
            GameLevelComponent hexLevel = Mapper.LevelSelect.INSTANCE.getGameLevel().get(entity);
            if (hexLevel.getFinished()) {
                UiComponentsKt.getSpriteBatch().setColor(ColorKt.color(0.3f, 0.3f, 0.3f, 1.0f));
            } else if (hexLevel.getRequirement() > clearedMaps) {
                UiComponentsKt.getSpriteBatch().setColor(ColorKt.color(0.5f, 0.5f, 1.0f, 1.0f));
            } else {
                UiComponentsKt.getSpriteBatch().setColor(ColorKt.color(1.0f, 1.0f, 1.0f, 1.0f));
            }
            Vector2 bl2 = this.getHexLayout().spriteSize();
            float xs = Vector2Kt.component1(bl2);
            float ys = Vector2Kt.component2(bl2);
            Vector2 size = new Vector2(xs, ys);
            SpriteBatch spriteBatch = UiComponentsKt.getSpriteBatch();
            TextureRegion textureRegion = hexLevel.getArea().getIcon();
            Vector2 vector2 = Vector2Kt.copy(size).scl(0.5f);
            Intrinsics.checkNotNullExpressionValue(vector2, "size.copy().scl(0.5f)");
            GdxUtilsKt.draw(spriteBatch, textureRegion, Vector2Kt.dw(Vector2Kt.minus(position, vector2)), Vector2Kt.dw(size));
        }
        if (selectedLevel != null) {
            Hex hex;
            BitmapFont bitmapFont;
            void $this$filterTo$iv$iv2;
            Object element$iv;
            Object $this$filter$iv2 = levels;
            boolean $i$f$filter2 = false;
            element$iv = $this$filter$iv2;
            Collection destination$iv$iv3 = new ArrayList();
            boolean $i$f$filterTo2 = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv2) {
                GameLevelComponent it = (GameLevelComponent)element$iv$iv;
                boolean bl = false;
                if (!it.getFinished()) continue;
                destination$iv$iv3.add(element$iv$iv);
            }
            int cleared = ((List)destination$iv$iv3).size();
            $this$filter$iv2 = Vector2Kt.dw(Vector2Kt.x(10.0f, 7.0f));
            float tx = Vector2Kt.component1((Vector2)$this$filter$iv2);
            float ty = Vector2Kt.component2((Vector2)$this$filter$iv2);
            String text = selectedLevel.getArea().getDescription();
            int requirement = selectedLevel.getRequirement();
            AssetManager element$iv$iv = this.am;
            AssetRef assetRef$iv = Asset.Font.INSTANCE.getJbt26();
            boolean $i$f$get = false;
            try {
                void this_$iv;
                Object object = this_$iv.getAssets().get(assetRef$iv);
                if (object == null) {
                    throw new NullPointerException("null cannot be cast to non-null type com.badlogic.gdx.graphics.g2d.BitmapFont");
                }
                bitmapFont = (BitmapFont)object;
            }
            catch (Exception ex$iv) {
                Log.INSTANCE.critical("AssetRef " + assetRef$iv + " not loaded");
                throw ex$iv;
            }
            BitmapFont font = bitmapFont;
            Batch batch = UiComponentsKt.getSpriteBatch();
            StringBuilder stringBuilder = new StringBuilder().append("Type: ").append(text).append(" - ");
            SelectedLevelComponent selectedLevelComponent = selectLevel;
            if (selectedLevelComponent == null) {
                hex = null;
            } else {
                GameLevelComponent gameLevelComponent = selectedLevelComponent.getSelected();
                hex = gameLevelComponent == null ? null : gameLevelComponent.getHex();
            }
            font.draw(batch, stringBuilder.append(hex).toString(), tx, ty);
            font.draw((Batch)UiComponentsKt.getSpriteBatch(), Intrinsics.stringPlus("Monsters: ", selectedLevel.getMonsters()), tx, ty - 70.0f);
            font.draw((Batch)UiComponentsKt.getSpriteBatch(), "Boss: 1", tx, ty - 120.0f);
            font.draw((Batch)UiComponentsKt.getSpriteBatch(), " - drops 1 item with 'movement speed'", tx, ty - 170.0f);
            font.draw((Batch)UiComponentsKt.getSpriteBatch(), " - drops 3 currency items", tx, ty - 220.0f);
            font.draw((Batch)UiComponentsKt.getSpriteBatch(), cleared >= requirement ? "[Space] to select" : "Requires " + requirement + " areas to be cleared", tx, ty - 320.0f);
        }
        UiComponentsKt.getSpriteBatch().end();
        UiComponentsKt.getShapeRenderer().begin(ShapeRenderer.ShapeType.Filled);
        if (selectedLevel != null) {
            Hex hex = selectedLevel.getHex();
            List<Pair<Vector2, Vector2>> lines = this.hexLayout.drawPolygon(hex);
            UiComponentsKt.getShapeRenderer().setColor(Color.LIGHT_GRAY);
            Iterable $this$forEachIndexed$iv = lines;
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                void $dstr$p1$p2;
                int n = index$iv;
                index$iv = n + 1;
                if (n < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                Pair assetRef$iv = (Pair)item$iv;
                int index = n;
                boolean bl = false;
                Vector2 p1 = (Vector2)$dstr$p1$p2.component1();
                Vector2 p2 = (Vector2)$dstr$p1$p2.component2();
                UiComponentsKt.getShapeRenderer().rectLine(Vector2Kt.dw(p1), Vector2Kt.dw(p2), 3.0f);
            }
            UiComponentsKt.getShapeRenderer().setColor(Color.WHITE);
        }
        UiComponentsKt.getShapeRenderer().end();
        Gdx.gl.glDisable(3042);
    }
}

