/*
 * Decompiled with CFR 0.152.
 */
package org.veiset.kgame.engine.ecs.core.system.player;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.graphics.glutils.ShapeRenderer;
import com.badlogic.gdx.math.Vector2;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import ktx.graphics.ColorKt;
import ktx.graphics.ShapeRendererKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.veiset.kgame.engine.Drawing;
import org.veiset.kgame.engine.GameFilesKt;
import org.veiset.kgame.engine.Log;
import org.veiset.kgame.engine.TBEngineKt;
import org.veiset.kgame.engine.asset.AssetManager;
import org.veiset.kgame.engine.asset.AssetRef;
import org.veiset.kgame.engine.ecs.core.system.player.ColoredMods;
import org.veiset.kgame.engine.item.DrawTextInfo;
import org.veiset.kgame.engine.item.Equipment;
import org.veiset.kgame.engine.item.ItemKt;
import org.veiset.kgame.engine.item.Weapon;
import org.veiset.kgame.engine.math.MathUtilsKt;
import org.veiset.kgame.engine.math.Vector2Kt;
import org.veiset.kgame.engine.modifier.Modifier;
import org.veiset.kgame.engine.util.FontUtilsKt;
import org.veiset.kgame.engine.util.GdxUtilsKt;
import org.veiset.kgame.engine.values.Asset;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000J\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u001a6\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0000\u001a\u00020\u0001H\u0002\u001a$\u0010\r\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\f\u001a$\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\f\u001a\u0010\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a&\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0016\u001a/\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\n\b\u0002\u0010\u001c\u001a\u0004\u0018\u00010\u0016\u00a2\u0006\u0002\u0010\u001d\u001a(\u0010\u001e\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u001f\u001a\u00020\u00122\u0006\u0010 \u001a\u00020\u00122\u0006\u0010\u001a\u001a\u00020\u001bH\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"shapeRenderer", "Lcom/badlogic/gdx/graphics/glutils/ShapeRenderer;", "spriteBatch", "Lcom/badlogic/gdx/graphics/g2d/SpriteBatch;", "displayEquipmentInfo", "", "equipped", "Lorg/veiset/kgame/engine/item/Equipment;", "mods", "", "Lorg/veiset/kgame/engine/ecs/core/system/player/ColoredMods;", "position", "Lcom/badlogic/gdx/math/Vector2;", "drawEquipment", "drawEquipmentUI", "drawInventoryItem", "drawTriangle", "scale", "", "spacing", "yoffset", "index", "", "drawWeapon", "weapon", "Lorg/veiset/kgame/engine/item/Weapon;", "drawing", "Lorg/veiset/kgame/engine/Drawing;", "compareDPS", "(Lcom/badlogic/gdx/math/Vector2;Lorg/veiset/kgame/engine/item/Weapon;Lorg/veiset/kgame/engine/Drawing;Ljava/lang/Integer;)V", "drawWithinCamera", "height", "width", "kgame2"})
public final class InventorySystemKt {
    @NotNull
    private static final ShapeRenderer shapeRenderer = TBEngineKt.getGlobals().getDrawUi().getShapeRenderer();
    @NotNull
    private static final SpriteBatch spriteBatch = TBEngineKt.getGlobals().getDrawUi().getSpriteBatch();

    public static final void drawTriangle(float scale, float spacing2, float yoffset, int index) {
        float gameWidth = 16.0f;
        Vector2 vector2 = InventorySystemKt.drawTriangle$trianglePos(gameWidth, scale, spacing2, index);
        float x = Vector2Kt.component1(vector2);
        float y = Vector2Kt.component2(vector2);
        Gdx.gl.glEnable(3042);
        Gdx.gl.glBlendFunc(770, 771);
        shapeRenderer.setColor(ColorKt.color(0.0f, 0.0f, 0.0f, 0.7f));
        shapeRenderer.begin(ShapeRenderer.ShapeType.Filled);
        shapeRenderer.triangle((x + scale / 2.0f - scale / 4.0f) * 120.0f, (y + yoffset) * 120.0f, (x + scale / 2.0f + scale / 4.0f) * 120.0f, (y + yoffset) * 120.0f, (x + scale / 2.0f) * 120.0f, (y - spacing2) * 120.0f);
        shapeRenderer.end();
        Gdx.gl.glDisable(3042);
    }

    private static final Vector2 drawWithinCamera(Vector2 position, float height, float width, Drawing drawing) {
        float x = Vector2Kt.component1(position);
        float y = Vector2Kt.component2(position);
        float cameraX = drawing.getCamera().position.x / 120.0f;
        float cameraY = drawing.getCamera().position.y / 120.0f;
        float maxHeight = cameraY + 4.5f;
        float maxWidth = cameraX + 8.0f;
        float newY = y + height > maxHeight ? y - height - 0.5f : y;
        float newX = x + width > maxWidth ? x - width + 0.1f : x;
        return Vector2Kt.x(newX, newY);
    }

    /*
     * WARNING - void declaration
     */
    public static final void drawWeapon(@NotNull Vector2 position, @NotNull Weapon weapon, @NotNull Drawing drawing, @Nullable Integer compareDPS) {
        TextureRegion textureRegion;
        void assetRef$iv;
        Object it;
        Object item$iv$iv3;
        Iterable $this$mapTo$iv$iv;
        Collection<String> collection;
        void $this$mapTo$iv$iv2;
        void $this$map$iv;
        void $this$sortedByDescending$iv;
        Collection destination$iv$iv;
        Iterable $this$filter$iv;
        List list;
        BitmapFont bitmapFont;
        BitmapFont bitmapFont2;
        BitmapFont bitmapFont3;
        AssetManager am;
        Intrinsics.checkNotNullParameter(position, "position");
        Intrinsics.checkNotNullParameter(weapon, "weapon");
        Intrinsics.checkNotNullParameter(drawing, "drawing");
        SpriteBatch sb = drawing.getSpriteBatch();
        ShapeRenderer sr = drawing.getShapeRenderer();
        AssetManager assetManager = am = TBEngineKt.getGlobals().getAssetManager();
        Object assetRef$iv2 = Asset.Font.INSTANCE.getRetron24();
        boolean $i$f$get = false;
        try {
            void this_$iv;
            Object object = this_$iv.getAssets().get(assetRef$iv2);
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.badlogic.gdx.graphics.g2d.BitmapFont");
            }
            bitmapFont3 = (BitmapFont)object;
        }
        catch (Exception ex$iv) {
            Log.INSTANCE.critical("AssetRef " + assetRef$iv2 + " not loaded");
            throw ex$iv;
        }
        BitmapFont font = bitmapFont3;
        assetRef$iv2 = am;
        Object assetRef$iv3 = Asset.Font.INSTANCE.getRetron18();
        boolean $i$f$get2 = false;
        try {
            void this_$iv;
            Object object = this_$iv.getAssets().get(assetRef$iv3);
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.badlogic.gdx.graphics.g2d.BitmapFont");
            }
            bitmapFont2 = (BitmapFont)object;
        }
        catch (Exception ex$iv) {
            Log.INSTANCE.critical("AssetRef " + assetRef$iv3 + " not loaded");
            throw ex$iv;
        }
        BitmapFont modifierFont = bitmapFont2;
        assetRef$iv3 = am;
        AssetRef assetRef$iv4 = Asset.Font.INSTANCE.getRetron14();
        boolean $i$f$get3 = false;
        try {
            void this_$iv;
            Object object = this_$iv.getAssets().get(assetRef$iv4);
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.badlogic.gdx.graphics.g2d.BitmapFont");
            }
            bitmapFont = (BitmapFont)object;
        }
        catch (Exception ex$iv) {
            Log.INSTANCE.critical("AssetRef " + assetRef$iv4 + " not loaded");
            throw ex$iv;
        }
        BitmapFont modifierSmallFont = bitmapFont;
        float padding = 0.2f;
        float modPadding = 0.13f;
        if (GameFilesKt.getGameConfig().getGameDisplayAllMods() || Gdx.input.isKeyPressed(57)) {
            list = weapon.getBaseAttack().getModifiers();
        } else {
            void $this$filterTo$iv$iv;
            $this$filter$iv = weapon.getBaseAttack().getModifiers();
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                Modifier it2 = (Modifier)element$iv$iv;
                boolean bl = false;
                boolean bl2 = !(it2 instanceof Modifier.Attack.AttackSpeed || it2 instanceof Modifier.Damage.Flat || it2 instanceof Modifier.Damage.Increase || it2 instanceof Modifier.Attack.CriticalDamage || it2 instanceof Modifier.Attack.CriticalChance);
                if (!bl2) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            list = (List)destination$iv$iv;
        }
        $this$filter$iv = list;
        boolean $i$f$sortedByDescending22 = false;
        List mods = CollectionsKt.sortedWith($this$sortedByDescending$iv, new Comparator(){

            public final int compare(T a, T b) {
                Modifier it = (Modifier)b;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(it.getSort());
                it = (Modifier)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues(comparable2, it.getSort());
            }
        });
        Iterable $i$f$sortedByDescending22 = mods;
        String string2 = weapon.getName();
        BitmapFont bitmapFont4 = modifierFont;
        Object object = font;
        boolean $i$f$map = false;
        destination$iv$iv = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
            void it3;
            Modifier bl = (Modifier)item$iv$iv2;
            collection = destination$iv$iv2;
            boolean bl3 = false;
            collection.add(it3.getDescription());
        }
        collection = (List)destination$iv$iv2;
        DrawTextInfo textSizes = ItemKt.textSizeInfo((BitmapFont)object, bitmapFont4, string2, (List<String>)collection);
        float modSizeY = mods.isEmpty() ? padding * 1.5f : (textSizes.getMaxModSize().y + modPadding) * (float)mods.size() + modPadding * 0.3f;
        float nameSizeY = textSizes.getNameSize().y;
        float nameSizeX = textSizes.getNameSize().x;
        Iterable $this$map$iv2 = mods;
        boolean $i$f$map2 = false;
        Iterable it3 = $this$map$iv2;
        Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv2, 10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv3 : $this$mapTo$iv$iv) {
            Modifier modifier = (Modifier)item$iv$iv3;
            object = destination$iv$iv3;
            boolean bl = false;
            object.add(((Modifier)it).getDescription());
        }
        $this$map$iv2 = (List)destination$iv$iv3;
        $i$f$map2 = false;
        $this$mapTo$iv$iv = $this$map$iv2;
        destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv2, 10));
        $i$f$mapTo2 = false;
        for (Object item$iv$iv3 : $this$mapTo$iv$iv) {
            it = (String)item$iv$iv3;
            object = destination$iv$iv3;
            boolean bl = false;
            object.add(Float.valueOf(FontUtilsKt.sizeX(modifierFont, (String)it)));
        }
        Object t = CollectionsKt.maxOrNull((List)destination$iv$iv3);
        float longestText = Math.max(Math.max(t == null ? 0.0f : ((Float)t).floatValue(), nameSizeY * 2.0f + nameSizeX), 2.0f);
        float weaponDescriptionHeight = textSizes.getMaxModSize().y * 3.0f + padding * 2.5f;
        float height = modSizeY + nameSizeY + padding * 2.0f + weaponDescriptionHeight;
        Vector2 vector2 = InventorySystemKt.drawWithinCamera(position, height, longestText, drawing);
        float startWidth = Vector2Kt.component1(vector2);
        float startHeight = Vector2Kt.component2(vector2);
        float yStartPos = startHeight + height - padding;
        float xStartPos = startWidth + padding;
        Gdx.gl.glEnable(3042);
        Gdx.gl.glBlendFunc(770, 771);
        sr.begin(ShapeRenderer.ShapeType.Filled);
        sr.setColor(ColorKt.color(0.0f, 0.0f, 0.0f, 0.7f));
        ShapeRendererKt.rect(sr, Vector2Kt.dw(Vector2Kt.x(startWidth, startHeight)), Vector2Kt.dw(Vector2Kt.x(longestText + padding * 2.0f, height)));
        sr.end();
        sr.begin(ShapeRenderer.ShapeType.Line);
        sr.setColor(ColorKt.color(0.0f, 0.0f, 0.0f, 1.0f));
        ShapeRendererKt.rect(sr, Vector2Kt.dw(Vector2Kt.x(startWidth, startHeight)), Vector2Kt.dw(Vector2Kt.x(longestText + padding * 2.0f, height)));
        sr.end();
        Gdx.gl.glDisable(3042);
        sb.begin();
        font.setColor(Color.GOLD);
        GdxUtilsKt.draw(font, sb, weapon.getName(), Vector2Kt.dw(Vector2Kt.x(xStartPos, yStartPos)));
        item$iv$iv3 = am;
        it = weapon.getIcon();
        object = sb;
        boolean $i$f$get4 = false;
        try {
            void this_$iv;
            Object object2 = this_$iv.getAssets().get(assetRef$iv);
            if (object2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.badlogic.gdx.graphics.g2d.TextureRegion");
            }
            textureRegion = (TextureRegion)object2;
        }
        catch (Exception ex$iv) {
            Log.INSTANCE.critical("AssetRef " + assetRef$iv + " not loaded");
            throw ex$iv;
        }
        ((SpriteBatch)object).draw(textureRegion, (xStartPos + nameSizeX + nameSizeY - padding / 2.0f) * 120.0f, (yStartPos - nameSizeY - padding / 2.0f) * 120.0f, (nameSizeY + padding) * 120.0f, (nameSizeY + padding) * 120.0f);
        modifierFont.setColor(weapon.getBaseAttack().getAttackType().getColor());
        float dpsTextLength = FontUtilsKt.sizeX(modifierFont, weapon.getBaseAttack().getDps() + " DPS");
        GdxUtilsKt.draw(modifierFont, sb, weapon.getBaseAttack().getAttackType().getName(), Vector2Kt.dw(Vector2Kt.x(xStartPos, yStartPos - 0.3f)));
        modifierFont.setColor(Color.WHITE);
        GdxUtilsKt.draw(modifierFont, sb, weapon.getBaseAttack().getDps() + " DPS", Vector2Kt.dw(Vector2Kt.x(xStartPos + longestText - dpsTextLength, yStartPos - 0.3f)));
        if (compareDPS != null) {
            int dpsResult = weapon.getBaseAttack().getDps() - compareDPS;
            String dpsResultStr = dpsResult >= 0 ? "+ " + dpsResult + " DPS" : "- " + Math.abs(dpsResult) + " DPS";
            float dpsCompareLength = FontUtilsKt.sizeX(modifierFont, dpsResultStr);
            float comparePos = xStartPos + longestText - dpsCompareLength;
            modifierFont.setColor(dpsResult >= 0 ? Color.GREEN : Color.RED);
            GdxUtilsKt.draw(modifierFont, sb, dpsResultStr, Vector2Kt.dw(Vector2Kt.x(comparePos, yStartPos - 0.48f)));
        }
        float headerOffset = 0.5f;
        float summaryPadding = 0.18f;
        float summaryXPadding = 0.07f;
        String avgDamage = "" + (int)weapon.getBaseAttack().getMinDamage() + '-' + (int)weapon.getBaseAttack().getMaxDamage();
        float avgDamageLength = FontUtilsKt.sizeX(modifierSmallFont, Intrinsics.stringPlus(avgDamage, " "));
        modifierSmallFont.setColor(Color.GREEN);
        GdxUtilsKt.draw(modifierSmallFont, sb, avgDamage, Vector2Kt.dw(Vector2Kt.x(xStartPos + summaryXPadding, yStartPos - headerOffset)));
        modifierSmallFont.setColor(Color.WHITE);
        GdxUtilsKt.draw(modifierSmallFont, sb, "damage", Vector2Kt.dw(Vector2Kt.x(xStartPos + summaryXPadding + avgDamageLength, yStartPos - headerOffset)));
        String criticalChance = "" + MathUtilsKt.percent(weapon.getBaseAttack().getCriticalChance()) + '%';
        float criticalLength = FontUtilsKt.sizeX(modifierSmallFont, Intrinsics.stringPlus(criticalChance, " "));
        modifierSmallFont.setColor(Color.ORANGE);
        GdxUtilsKt.draw(modifierSmallFont, sb, criticalChance, Vector2Kt.dw(Vector2Kt.x(xStartPos + summaryXPadding, yStartPos - headerOffset - summaryPadding)));
        modifierSmallFont.setColor(Color.WHITE);
        GdxUtilsKt.draw(modifierSmallFont, sb, "critical chance", Vector2Kt.dw(Vector2Kt.x(xStartPos + summaryXPadding + criticalLength, yStartPos - headerOffset - summaryPadding)));
        String asp = String.valueOf(MathUtilsKt.round(weapon.getBaseAttack().getAttackSpeed(), 2));
        float aspLength = FontUtilsKt.sizeX(modifierSmallFont, Intrinsics.stringPlus(asp, " "));
        modifierSmallFont.setColor(Color.YELLOW);
        GdxUtilsKt.draw(modifierSmallFont, sb, asp, Vector2Kt.dw(Vector2Kt.x(xStartPos + summaryXPadding, yStartPos - headerOffset - summaryPadding * 2.0f)));
        modifierSmallFont.setColor(Color.WHITE);
        GdxUtilsKt.draw(modifierSmallFont, sb, "attacks per second", Vector2Kt.dw(Vector2Kt.x(xStartPos + summaryXPadding + aspLength, yStartPos - headerOffset - summaryPadding * 2.0f)));
        modifierFont.setColor(Color.WHITE);
        Iterable $this$forEachIndexed$iv = mods;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void mod;
            int n = index$iv;
            index$iv = n + 1;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Modifier modifier = (Modifier)item$iv;
            int i = n;
            boolean bl = false;
            modifierFont.setColor(mod.getColor());
            modifierFont.draw((Batch)sb, mod.getDescription(), xStartPos * 120.0f, (yStartPos - weaponDescriptionHeight - modPadding * 1.3f - nameSizeY - (float)i * (textSizes.getMaxModSize().y + modPadding)) * 120.0f);
        }
        sb.end();
    }

    public static /* synthetic */ void drawWeapon$default(Vector2 vector2, Weapon weapon, Drawing drawing, Integer n, int n2, Object object) {
        if ((n2 & 8) != 0) {
            n = null;
        }
        InventorySystemKt.drawWeapon(vector2, weapon, drawing, n);
    }

    /*
     * WARNING - void declaration
     */
    private static final void drawInventoryItem(Equipment equipped) {
        String it;
        Iterable $this$mapTo$iv$iv;
        BitmapFont bitmapFont;
        BitmapFont bitmapFont2;
        Object object;
        Collection collection;
        void $this$mapTo$iv$iv2;
        AssetManager am = TBEngineKt.getGlobals().getAssetManager();
        float spacing2 = 0.05f;
        float yoffset = 0.15f;
        float padding = 0.2f;
        float gameWidth = 16.0f;
        List<Modifier> mods = equipped.modifiers();
        Iterable $this$map$iv = mods;
        boolean $i$f$map22 = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it2;
            Modifier modifier = (Modifier)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            String string2 = it2.getDescription();
            object = Color.WHITE;
            Intrinsics.checkNotNullExpressionValue(object, "WHITE");
            collection.add(new ColoredMods(string2, (Color)object, Float.valueOf(0.0f)));
        }
        List coloredMods = (List)destination$iv$iv;
        AssetManager $i$f$map22 = am;
        Object assetRef$iv = Asset.Font.INSTANCE.getRetron24();
        boolean $i$f$get = false;
        try {
            void this_$iv;
            Object object2 = this_$iv.getAssets().get(assetRef$iv);
            if (object2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.badlogic.gdx.graphics.g2d.BitmapFont");
            }
            bitmapFont2 = (BitmapFont)object2;
        }
        catch (Exception ex$iv) {
            Log.INSTANCE.critical("AssetRef " + assetRef$iv + " not loaded");
            throw ex$iv;
        }
        BitmapFont font = bitmapFont2;
        assetRef$iv = am;
        AssetRef assetRef$iv2 = Asset.Font.INSTANCE.getRetron24();
        boolean $i$f$get2 = false;
        try {
            void this_$iv;
            Object object3 = this_$iv.getAssets().get(assetRef$iv2);
            if (object3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.badlogic.gdx.graphics.g2d.BitmapFont");
            }
            bitmapFont = (BitmapFont)object3;
        }
        catch (Exception ex$iv) {
            Log.INSTANCE.critical("AssetRef " + assetRef$iv2 + " not loaded");
            throw ex$iv;
        }
        BitmapFont modFont = bitmapFont;
        DrawTextInfo textSizes = ItemKt.textSizes(equipped, font, modFont);
        float nameSizeY = textSizes.getNameSize().y;
        float nameSizeX = textSizes.getNameSize().x;
        Iterable $this$map$iv2 = mods;
        boolean $i$f$map = false;
        object = $this$map$iv2;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv2, 10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Modifier modifier = (Modifier)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl = false;
            collection.add(((Modifier)((Object)it)).getDescription());
        }
        $this$map$iv2 = (List)destination$iv$iv2;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv2;
        destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv2, 10));
        $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (String)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl = false;
            collection.add(Float.valueOf(FontUtilsKt.sizeX(font, it)));
        }
        Object t = CollectionsKt.maxOrNull((List)destination$iv$iv2);
        float longestText = Math.max(t == null ? 0.0f : ((Float)t).floatValue(), nameSizeY * 2.0f + nameSizeX);
        float startWidth = gameWidth - (longestText + spacing2) - padding * 2.0f;
        float startHeight = 0.65f + spacing2 * (float)2 + yoffset;
        InventorySystemKt.drawEquipmentUI(equipped, coloredMods, Vector2Kt.x(startWidth, startHeight));
    }

    public static final void drawEquipmentUI(@NotNull Equipment equipped, @NotNull List<ColoredMods> mods, @NotNull Vector2 position) {
        Intrinsics.checkNotNullParameter(equipped, "equipped");
        Intrinsics.checkNotNullParameter(mods, "mods");
        Intrinsics.checkNotNullParameter(position, "position");
        InventorySystemKt.displayEquipmentInfo(equipped, mods, position, TBEngineKt.getGlobals().getDrawUi().getSpriteBatch(), TBEngineKt.getGlobals().getDrawUi().getShapeRenderer());
    }

    public static final void drawEquipment(@NotNull Equipment equipped, @NotNull List<ColoredMods> mods, @NotNull Vector2 position) {
        Intrinsics.checkNotNullParameter(equipped, "equipped");
        Intrinsics.checkNotNullParameter(mods, "mods");
        Intrinsics.checkNotNullParameter(position, "position");
        InventorySystemKt.displayEquipmentInfo(equipped, mods, position, TBEngineKt.getGlobals().getDrawGfx().getSpriteBatch(), TBEngineKt.getGlobals().getDrawGfx().getShapeRenderer());
    }

    /*
     * WARNING - void declaration
     */
    private static final void displayEquipmentInfo(Equipment equipped, List<ColoredMods> mods, Vector2 position, SpriteBatch spriteBatch, ShapeRenderer shapeRenderer) {
        TextureRegion textureRegion;
        void assetRef$iv;
        String it;
        Object item$iv$iv;
        Object $this$mapTo$iv$iv;
        Iterable it2;
        Collection<String> collection;
        void $this$mapTo$iv$iv2;
        void $this$map$iv;
        BitmapFont bitmapFont;
        BitmapFont bitmapFont2;
        AssetManager am;
        float padding = 0.2f;
        float modPadding = 0.15f;
        float startWidth = Vector2Kt.component1(position);
        float startHeight = Vector2Kt.component2(position);
        AssetManager assetManager = am = TBEngineKt.getGlobals().getAssetManager();
        Object assetRef$iv2 = Asset.Font.INSTANCE.getRetron24();
        boolean $i$f$get = false;
        try {
            void this_$iv;
            Object object = this_$iv.getAssets().get(assetRef$iv2);
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.badlogic.gdx.graphics.g2d.BitmapFont");
            }
            bitmapFont2 = (BitmapFont)object;
        }
        catch (Exception ex$iv) {
            Log.INSTANCE.critical("AssetRef " + assetRef$iv2 + " not loaded");
            throw ex$iv;
        }
        BitmapFont font = bitmapFont2;
        assetRef$iv2 = am;
        Object assetRef$iv3 = Asset.Font.INSTANCE.getRetron24();
        boolean $i$f$get2 = false;
        try {
            void this_$iv;
            Object object = this_$iv.getAssets().get(assetRef$iv3);
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.badlogic.gdx.graphics.g2d.BitmapFont");
            }
            bitmapFont = (BitmapFont)object;
        }
        catch (Exception ex$iv) {
            Log.INSTANCE.critical("AssetRef " + assetRef$iv3 + " not loaded");
            throw ex$iv;
        }
        BitmapFont modFont = bitmapFont;
        assetRef$iv3 = mods;
        String string2 = equipped.getName();
        BitmapFont bitmapFont3 = modFont;
        Object object = font;
        boolean $i$f$map = false;
        void ex$iv = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
            ColoredMods coloredMods = (ColoredMods)item$iv$iv2;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(((ColoredMods)((Object)it2)).getDescription());
        }
        collection = (List)destination$iv$iv;
        DrawTextInfo textSizes = ItemKt.textSizeInfo((BitmapFont)object, bitmapFont3, string2, (List<String>)collection);
        float modSizeY = mods.isEmpty() ? 0.0f : (textSizes.getMaxModSize().y + modPadding) * (float)mods.size() + modPadding * 0.3f;
        float nameSizeY = textSizes.getNameSize().y;
        float nameSizeX = textSizes.getNameSize().x;
        Iterable $this$map$iv2 = mods;
        boolean $i$f$map2 = false;
        it2 = $this$map$iv2;
        Object destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv2, 10));
        boolean $i$f$mapTo2 = false;
        Iterator iterator2 = $this$mapTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            item$iv$iv = iterator2.next();
            ColoredMods coloredMods = (ColoredMods)item$iv$iv;
            object = destination$iv$iv2;
            boolean bl = false;
            object.add(((ColoredMods)((Object)it)).getDescription());
        }
        $this$map$iv2 = (List)destination$iv$iv2;
        $i$f$map2 = false;
        $this$mapTo$iv$iv = $this$map$iv2;
        destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv2, 10));
        $i$f$mapTo2 = false;
        iterator2 = $this$mapTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            item$iv$iv = iterator2.next();
            it = (String)item$iv$iv;
            object = destination$iv$iv2;
            boolean bl = false;
            object.add(Float.valueOf(FontUtilsKt.sizeX(font, it)));
        }
        Object t = CollectionsKt.maxOrNull((List)destination$iv$iv2);
        float longestText = Math.max(t == null ? 0.0f : ((Float)t).floatValue(), nameSizeY * 2.0f + nameSizeX);
        float height = modSizeY + nameSizeY + padding * 2.0f;
        float yStartPos = startHeight + height - padding;
        float xStartPos = startWidth + padding;
        Gdx.gl.glEnable(3042);
        Gdx.gl.glBlendFunc(770, 771);
        shapeRenderer.begin(ShapeRenderer.ShapeType.Filled);
        shapeRenderer.setColor(ColorKt.color(0.0f, 0.0f, 0.0f, 0.7f));
        ShapeRendererKt.rect(shapeRenderer, Vector2Kt.dw(Vector2Kt.x(startWidth, startHeight)), Vector2Kt.x((longestText + padding * 2.0f) * 120.0f, height * 120.0f));
        shapeRenderer.end();
        shapeRenderer.begin(ShapeRenderer.ShapeType.Line);
        shapeRenderer.setColor(ColorKt.color(0.0f, 0.0f, 0.0f, 1.0f));
        ShapeRendererKt.rect(shapeRenderer, Vector2Kt.dw(Vector2Kt.x(startWidth, startHeight)), Vector2Kt.x((longestText + padding * 2.0f) * 120.0f, height * 120.0f));
        shapeRenderer.end();
        Gdx.gl.glDisable(3042);
        spriteBatch.begin();
        font.setColor(Color.GOLD);
        font.draw((Batch)spriteBatch, equipped.getName(), xStartPos * 120.0f, yStartPos * 120.0f);
        $this$mapTo$iv$iv = am;
        destination$iv$iv2 = equipped.getIcon();
        object = spriteBatch;
        boolean $i$f$get3 = false;
        try {
            void this_$iv;
            Object object2 = this_$iv.getAssets().get(assetRef$iv);
            if (object2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.badlogic.gdx.graphics.g2d.TextureRegion");
            }
            textureRegion = (TextureRegion)object2;
        }
        catch (Exception ex$iv2) {
            Log.INSTANCE.critical("AssetRef " + assetRef$iv + " not loaded");
            throw ex$iv2;
        }
        ((SpriteBatch)object).draw(textureRegion, (xStartPos + nameSizeX + nameSizeY - padding / 2.0f) * 120.0f, (yStartPos - nameSizeY - padding / 2.0f) * 120.0f, (nameSizeY + padding) * 120.0f, (nameSizeY + padding) * 120.0f);
        Iterable $this$forEachIndexed$iv = mods;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void mod;
            int n = index$iv;
            index$iv = n + 1;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            ColoredMods bl = (ColoredMods)item$iv;
            int i = n;
            boolean bl2 = false;
            font.setColor(mod.getColor());
            font.draw((Batch)spriteBatch, mod.getDescription(), xStartPos * 120.0f, (yStartPos - modPadding * 1.3f - nameSizeY - (float)i * (textSizes.getMaxModSize().y + modPadding)) * 120.0f);
        }
        spriteBatch.end();
    }

    private static final Vector2 drawTriangle$trianglePos(float gameWidth, float $scale, float $spacing, int index) {
        float x = gameWidth - $scale * (float)index - $spacing * (float)index;
        return new Vector2(x, $spacing * (float)2 + $scale);
    }

    public static final /* synthetic */ ShapeRenderer access$getShapeRenderer$p() {
        return shapeRenderer;
    }

    public static final /* synthetic */ SpriteBatch access$getSpriteBatch$p() {
        return spriteBatch;
    }

    public static final /* synthetic */ void access$drawInventoryItem(Equipment equipped) {
        InventorySystemKt.drawInventoryItem(equipped);
    }
}

