/*
 * Decompiled with CFR 0.152.
 */
package org.veiset.kgame.engine.ecs.core.system.scenario;

import com.badlogic.ashley.core.Engine;
import com.badlogic.ashley.core.Entity;
import com.badlogic.ashley.core.EntitySystem;
import com.badlogic.ashley.core.Family;
import com.badlogic.ashley.utils.ImmutableArray;
import com.badlogic.gdx.audio.Sound;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.math.Vector3;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.veiset.kgame.engine.GameFilesKt;
import org.veiset.kgame.engine.Log;
import org.veiset.kgame.engine.TBEngineKt;
import org.veiset.kgame.engine.asset.AssetManager;
import org.veiset.kgame.engine.asset.AssetRef;
import org.veiset.kgame.engine.ecs.core.component.PositionComponent;
import org.veiset.kgame.engine.ecs.core.component.camera.CameraFollowComponent;
import org.veiset.kgame.engine.ecs.core.component.player.PlayerCharacterComponent;
import org.veiset.kgame.engine.ecs.core.component.scenario.BossScenarioComponent;
import org.veiset.kgame.engine.ecs.core.entity.PauseEntity;
import org.veiset.kgame.engine.ecs.core.system.Mapper;
import org.veiset.kgame.engine.ecs.core.system.scenario.DrawBossFrame;
import org.veiset.kgame.engine.ecs.core.system.scenario.ScenarioBossSystemKt;
import org.veiset.kgame.engine.math.Vector2Kt;
import org.veiset.kgame.engine.values.Asset;
import org.veiset.kgame.engine.world.WorldMapBounds;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u0016H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082.\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/veiset/kgame/engine/ecs/core/system/scenario/ScenarioBossSystem;", "Lcom/badlogic/ashley/core/EntitySystem;", "worldMapBounds", "Lorg/veiset/kgame/engine/world/WorldMapBounds;", "(Lorg/veiset/kgame/engine/world/WorldMapBounds;)V", "am", "Lorg/veiset/kgame/engine/asset/AssetManager;", "cameraFollowEntities", "Lcom/badlogic/ashley/utils/ImmutableArray;", "Lcom/badlogic/ashley/core/Entity;", "drawBossFrame", "Lorg/veiset/kgame/engine/ecs/core/system/scenario/DrawBossFrame;", "getDrawBossFrame", "()Lorg/veiset/kgame/engine/ecs/core/system/scenario/DrawBossFrame;", "playerEntities", "scenarios", "addedToEngine", "", "engine", "Lcom/badlogic/ashley/core/Engine;", "update", "deltaTime", "", "kgame2"})
public final class ScenarioBossSystem
extends EntitySystem {
    @NotNull
    private final WorldMapBounds worldMapBounds;
    @NotNull
    private final AssetManager am;
    private ImmutableArray<Entity> playerEntities;
    private ImmutableArray<Entity> cameraFollowEntities;
    private ImmutableArray<Entity> scenarios;
    @NotNull
    private final DrawBossFrame drawBossFrame;

    public ScenarioBossSystem(@NotNull WorldMapBounds worldMapBounds) {
        Intrinsics.checkNotNullParameter(worldMapBounds, "worldMapBounds");
        this.worldMapBounds = worldMapBounds;
        this.am = TBEngineKt.getGlobals().getAssetManager();
        this.drawBossFrame = new DrawBossFrame(0.0f, 0.0f, 3, null);
    }

    @NotNull
    public final DrawBossFrame getDrawBossFrame() {
        return this.drawBossFrame;
    }

    @Override
    public void addedToEngine(@NotNull Engine engine) {
        Intrinsics.checkNotNullParameter(engine, "engine");
        Class[] classArray = new Class[]{PositionComponent.class, PlayerCharacterComponent.class};
        ImmutableArray<Entity> immutableArray = engine.getEntitiesFor(Family.all(classArray).get());
        Intrinsics.checkNotNullExpressionValue(immutableArray, "engine.getEntitiesFor(Fa\u2026onent::class.java).get())");
        this.playerEntities = immutableArray;
        classArray = new Class[]{PositionComponent.class, CameraFollowComponent.class};
        immutableArray = engine.getEntitiesFor(Family.all(classArray).get());
        Intrinsics.checkNotNullExpressionValue(immutableArray, "engine.getEntitiesFor(Fa\u2026onent::class.java).get())");
        this.cameraFollowEntities = immutableArray;
        classArray = new Class[]{BossScenarioComponent.class};
        immutableArray = engine.getEntitiesFor(Family.all(classArray).get());
        Intrinsics.checkNotNullExpressionValue(immutableArray, "engine.getEntitiesFor(Fa\u2026onent::class.java).get())");
        this.scenarios = immutableArray;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void update(float deltaTime) {
        ImmutableArray<Entity> immutableArray = this.scenarios;
        if (immutableArray == null) {
            Intrinsics.throwUninitializedPropertyAccessException("scenarios");
            immutableArray = null;
        }
        Entity entity = (Entity)CollectionsKt.firstOrNull((Iterable)immutableArray);
        if (entity == null) {
            return;
        }
        Entity scenario = entity;
        ImmutableArray<Entity> immutableArray2 = this.cameraFollowEntities;
        if (immutableArray2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("cameraFollowEntities");
            immutableArray2 = null;
        }
        Entity entity2 = (Entity)CollectionsKt.firstOrNull((Iterable)immutableArray2);
        if (entity2 == null) {
            return;
        }
        Entity cameraFollowEntity = entity2;
        CameraFollowComponent cameraFollow = Mapper.INSTANCE.getCameraFollow().get(cameraFollowEntity);
        ImmutableArray<Entity> immutableArray3 = this.playerEntities;
        if (immutableArray3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("playerEntities");
            immutableArray3 = null;
        }
        Entity entity3 = (Entity)CollectionsKt.firstOrNull((Iterable)immutableArray3);
        if (entity3 == null) {
            return;
        }
        Entity player = entity3;
        BossScenarioComponent scenarioComponent = Mapper.INSTANCE.getBossScenarioComponent().get(scenario);
        Entity boss = scenarioComponent.getTarget();
        Vector2 bossPos = Mapper.INSTANCE.getPosition().get(boss).getPos();
        Vector2 playerPos = Mapper.INSTANCE.getPosition().get(player).getPos();
        if (scenarioComponent.getStep() == 0 && scenarioComponent.getTrigger().inRange(bossPos, playerPos, ScenarioBossSystemKt.access$getCamera$p())) {
            Sound sound;
            Log.INSTANCE.info("Scenario step 1");
            this.drawBossFrame.reset();
            scenarioComponent.setStep(1);
            AssetManager assetManager = this.am;
            AssetRef assetRef$iv = Asset.Sound.INSTANCE.getZombieGroan();
            boolean $i$f$get = false;
            try {
                void this_$iv;
                Object object = this_$iv.getAssets().get(assetRef$iv);
                if (object == null) {
                    throw new NullPointerException("null cannot be cast to non-null type com.badlogic.gdx.audio.Sound");
                }
                sound = (Sound)object;
            }
            catch (Exception ex$iv) {
                Log.INSTANCE.critical("AssetRef " + assetRef$iv + " not loaded");
                throw ex$iv;
            }
            sound.play(GameFilesKt.getGameConfig().getVolumeEffect() * GameFilesKt.getGameConfig().getVolumeMaster(), 0.6f, 0.0f);
        } else {
            Vector3 vector3 = ScenarioBossSystemKt.access$getCamera$p().position;
            Intrinsics.checkNotNullExpressionValue(vector3, "camera.position");
            Vector2 cameraPos = Vector2Kt.gfxToWorld(Vector2Kt.v2(vector3));
            if (scenarioComponent.getStep() == 1 && (cameraPos.dst(bossPos) <= cameraFollow.getNoFollow() || this.worldMapBounds.isOnBound(cameraPos))) {
                Log.INSTANCE.info("Scenario step 2");
                scenarioComponent.setStep(2);
            } else if (scenarioComponent.getStep() == 2 && TBEngineKt.getGlobals().getKeyMapper().confirm() && this.drawBossFrame.fadeComplete()) {
                Log.INSTANCE.info("Scenario step 3");
                scenarioComponent.setStep(3);
            } else if (scenarioComponent.getStep() == 3 && (cameraPos.dst(playerPos) <= cameraFollow.getNoFollow() || this.worldMapBounds.isOnBound(cameraPos))) {
                Log.INSTANCE.info("Scenario step 4");
                scenarioComponent.setStep(4);
            }
        }
        if (scenarioComponent.getStep() == 1) {
            this.getEngine().addEntity(new PauseEntity(true, false, 0.0f, 6, null));
            cameraFollowEntity.remove(CameraFollowComponent.class);
            boss.add(new CameraFollowComponent(0.12f, 10.0f, 15.0f, 0.0f, 8, null));
        }
        if (scenarioComponent.getStep() == 2) {
            this.drawBossFrame.draw(deltaTime, boss, scenarioComponent.getText());
        }
        if (scenarioComponent.getStep() == 3) {
            player.add(new CameraFollowComponent(0.2f, 10.0f, 15.0f, 0.0f, 8, null));
            boss.remove(CameraFollowComponent.class);
        }
        if (scenarioComponent.getStep() == 4) {
            scenario.remove(BossScenarioComponent.class);
            player.add(new CameraFollowComponent(0.0f, 0.0f, 0.0f, 0.0f, 15, null));
            this.getEngine().addEntity(new PauseEntity(false, false, 0.0f, 6, null));
        }
    }
}

