/*
 * Decompiled with CFR 0.152.
 */
package org.veiset.kgame.engine.item;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.veiset.kgame.engine.item.Loot;
import org.veiset.kgame.engine.item.LootSimulatorKt;
import org.veiset.kgame.engine.item.LootSystem;
import org.veiset.kgame.engine.item.SimpleLootSystem;
import org.veiset.kgame.engine.item.TestItem;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000\"\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\u001a\u0006\u0010\u0000\u001a\u00020\u0001\u001a@\u0010\u0002\u001a\u00020\u0001\"\u0004\b\u0000\u0010\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0012\u0010\u0007\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00030\b0\u00052\u0006\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\n\u001a8\u0010\f\u001a\u00020\u0001\"\u0004\b\u0000\u0010\u00032\u0006\u0010\r\u001a\u00020\u00062\u0012\u0010\u0007\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00030\b0\u00052\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n\u001a2\u0010\u000e\u001a\u00020\u0001\"\u0004\b\u0000\u0010\u00032\u0012\u0010\u0007\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00030\b0\u00052\u0006\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\n\u001a\n\u0010\u000f\u001a\u00020\n*\u00020\n\u00a8\u0006\u0010"}, d2={"main", "", "simulate", "T", "lootSystems", "", "Lorg/veiset/kgame/engine/item/LootSystem;", "items", "Lorg/veiset/kgame/engine/item/Loot;", "repetitions", "", "barSize", "simulateResults", "lootSystem", "simulateSetup", "length", "kgame2"})
public final class LootSimulatorKt {
    public static final void main() {
        Object[] objectArray = new SimpleLootSystem[]{new SimpleLootSystem(0.0f, 0.0f, 1), new SimpleLootSystem(0.0f, 0.0f, 5), new SimpleLootSystem(0.5f, 0.5f, 2), new SimpleLootSystem(0.7f, 0.0f, 2), new SimpleLootSystem(0.0f, 0.7f, 2), new SimpleLootSystem(0.7f, 0.7f, 5), new SimpleLootSystem(1.0f, 1.0f, 1)};
        List<SimpleLootSystem> list = CollectionsKt.listOf(objectArray);
        objectArray = new Loot[]{new Loot<TestItem>(0.12f, 0.11f, new TestItem("Fireball")), new Loot<TestItem>(0.22f, 0.63f, new TestItem("Zip")), new Loot<TestItem>(0.25f, 0.84f, new TestItem("Dance")), new Loot<TestItem>(0.52f, 0.12f, new TestItem("Arc")), new Loot<TestItem>(0.87f, 0.23f, new TestItem("Melee"))};
        LootSimulatorKt.simulate$default(list, CollectionsKt.listOf(objectArray), 200000, 0, 8, null);
    }

    public static final int length(int $this$length) {
        return (int)Math.log10($this$length) + 1;
    }

    public static final <T> void simulate(@NotNull List<? extends LootSystem> lootSystems, @NotNull List<Loot<T>> items, int repetitions, int barSize) {
        Intrinsics.checkNotNullParameter(lootSystems, "lootSystems");
        Intrinsics.checkNotNullParameter(items, "items");
        LootSimulatorKt.simulateSetup(items, repetitions, barSize);
        boolean $i$f$measureTimeMillis = false;
        long start$iv = System.currentTimeMillis();
        boolean bl = false;
        Iterable $this$forEach$iv = lootSystems;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            LootSystem lootSystem = (LootSystem)element$iv;
            boolean bl2 = false;
            LootSimulatorKt.simulateResults(lootSystem, items, repetitions, barSize);
        }
        long time = System.currentTimeMillis() - start$iv;
        System.out.println((Object)StringsKt.trimIndent("\n\n        Done.\n        Repetitions: " + lootSystems.size() * repetitions + "\n        Simulation: " + time + " ms\n    "));
    }

    public static /* synthetic */ void simulate$default(List list, List list2, int n, int n2, int n3, Object object) {
        if ((n3 & 8) != 0) {
            n2 = 20;
        }
        LootSimulatorKt.simulate(list, list2, n, n2);
    }

    /*
     * WARNING - void declaration
     */
    public static final <T> void simulateSetup(@NotNull List<Loot<T>> items, int repetitions, int barSize) {
        void $this$mapIndexedTo$iv$iv;
        void $this$mapIndexed$iv;
        Intrinsics.checkNotNullParameter(items, "items");
        String spaces = StringsKt.repeat(" ", barSize + LootSimulatorKt.length(repetitions) + 14);
        Iterable iterable = items;
        boolean $i$f$mapIndexed = false;
        void var7_6 = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$mapIndexed$iv, 10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void it;
            void i;
            int n = index$iv$iv;
            index$iv$iv = n + 1;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Loot loot = (Loot)item$iv$iv;
            int n2 = n;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(StringsKt.padStart$default(String.valueOf((int)i), 6, '\u0000', 2, null) + ' ' + spaces + ' ' + it);
        }
        String itemString2 = CollectionsKt.joinToString$default((List)destination$iv$iv, "", null, null, 0, null, simulateSetup.itemString.2.INSTANCE, 30, null);
        System.out.println((Object)StringsKt.trimMargin$default("\n        |Starting simulation with config:\n        | Repetitions = " + repetitions + ", items = " + items.size() + "\n        |" + StringsKt.padStart$default("id", 6, '\u0000', 2, null) + ' ' + spaces + " Loot\n        | " + StringsKt.repeat("-", 60 + barSize) + "\n        |" + itemString2 + "\n        |\n    ", null, 1, null));
    }

    public static /* synthetic */ void simulateSetup$default(List list, int n, int n2, int n3, Object object) {
        if ((n3 & 4) != 0) {
            n2 = 20;
        }
        LootSimulatorKt.simulateSetup(list, n, n2);
    }

    /*
     * WARNING - void declaration
     */
    public static final <T> void simulateResults(@NotNull LootSystem lootSystem, @NotNull List<Loot<T>> items, int repetitions, int barSize) {
        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000)\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000*\u0001\u0000\b\u008a\b\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B\u001d\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u000f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0006H\u00c6\u0003J4\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00002\u000e\b\u0002\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001\u00a2\u0006\u0002\u0010\u0011J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0002H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0006H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\r\u00a8\u0006\u0018"}, d2={"org/veiset/kgame/engine/item/LootSimulatorKt$simulateResults$Result", "T", "", "loot", "Lorg/veiset/kgame/engine/item/Loot;", "times", "", "(Lorg/veiset/kgame/engine/item/Loot;I)V", "getLoot", "()Lorg/veiset/kgame/engine/item/Loot;", "getTimes", "()I", "setTimes", "(I)V", "component1", "component2", "copy", "(Lorg/veiset/kgame/engine/item/Loot;I)Lorg/veiset/kgame/engine/item/LootSimulatorKt$simulateResults$Result;", "equals", "", "other", "hashCode", "toString", "", "kgame2"})
        public final class Result<T> {
            @NotNull
            private final Loot<T> loot;
            private int times;

            public Result(@NotNull Loot<T> loot, int times) {
                Intrinsics.checkNotNullParameter(loot, "loot");
                this.loot = loot;
                this.times = times;
            }

            public /* synthetic */ Result(Loot loot, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n2 & 2) != 0) {
                    n = 0;
                }
                this(loot, n);
            }

            @NotNull
            public final Loot<T> getLoot() {
                return this.loot;
            }

            public final int getTimes() {
                return this.times;
            }

            public final void setTimes(int n) {
                this.times = n;
            }

            @NotNull
            public final Loot<T> component1() {
                return this.loot;
            }

            public final int component2() {
                return this.times;
            }

            @NotNull
            public final Result<T> copy(@NotNull Loot<T> loot, int times) {
                Intrinsics.checkNotNullParameter(loot, "loot");
                return new Result<T>(loot, times);
            }

            public static /* synthetic */ Result copy$default(Result result2, Loot loot, int n, int n2, Object object) {
                if ((n2 & 1) != 0) {
                    loot = result2.loot;
                }
                if ((n2 & 2) != 0) {
                    n = result2.times;
                }
                return result2.copy(loot, n);
            }

            @NotNull
            public String toString() {
                return "Result(loot=" + this.loot + ", times=" + this.times + ')';
            }

            public int hashCode() {
                int result2 = this.loot.hashCode();
                result2 = result2 * 31 + Integer.hashCode(this.times);
                return result2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Result)) {
                    return false;
                }
                Result result2 = (Result)other;
                if (!Intrinsics.areEqual(this.loot, result2.loot)) {
                    return false;
                }
                return this.times == result2.times;
            }
        }
        int n;
        int $i$f$forEach;
        Object $this$mapTo$iv$iv;
        Object object;
        void $this$mapIndexedTo$iv$iv;
        void $this$mapIndexed$iv22;
        Intrinsics.checkNotNullParameter(lootSystem, "lootSystem");
        Intrinsics.checkNotNullParameter(items, "items");
        Iterable iterable = items;
        int $i$f$mapIndexed = 0;
        void var7_8 = $this$mapIndexed$iv22;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$mapIndexed$iv22, 10));
        boolean $i$f$mapIndexedTo2 = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void loot;
            int n2 = index$iv$iv;
            index$iv$iv = n2 + 1;
            if (n2 < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Loot loot2 = (Loot)item$iv$iv;
            int n3 = n2;
            object = destination$iv$iv;
            boolean bl2 = false;
            object.add(new Result((Loot)loot, 0, 2, null));
        }
        List results = (List)destination$iv$iv;
        System.out.println((Object)StringsKt.trimMargin$default("\n        |Result:\n        | Repetitions = " + repetitions + ", items = " + items.size() + "\n        | Engine: " + lootSystem + "\n        | " + StringsKt.padStart$default("id", 5, '\u0000', 2, null) + ' ' + StringsKt.padEnd$default("Chance", barSize + 10, '\u0000', 2, null) + ' ' + StringsKt.padStart$default("Times", LootSimulatorKt.length(repetitions) + 1, '\u0000', 2, null) + "   Loot\n    ", null, 1, null));
        int $this$mapIndexed$iv22 = 0;
        while ($this$mapIndexed$iv22 < repetitions) {
            void $this$forEach$iv;
            Object item$iv$iv;
            Iterable $this$map$iv;
            int it = $i$f$mapIndexed = $this$mapIndexed$iv22++;
            boolean bl = false;
            if (it % (repetitions / (60 + barSize)) == 0) {
                System.out.print((Object)"-");
            }
            Iterable $i$f$mapIndexedTo2 = lootSystem.generateLoot(items);
            boolean $i$f$map = false;
            Iterator iterator2 = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            Iterator loot = $this$mapTo$iv$iv.iterator();
            while (loot.hasNext()) {
                void it2;
                item$iv$iv = loot.next();
                Loot bl2 = (Loot)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl3 = false;
                collection.add(items.indexOf(it2));
            }
            $this$map$iv = (List)destination$iv$iv2;
            $i$f$forEach = 0;
            $this$mapTo$iv$iv = $this$forEach$iv.iterator();
            while ($this$mapTo$iv$iv.hasNext()) {
                Object element$iv = $this$mapTo$iv$iv.next();
                int it3 = ((Number)element$iv).intValue();
                boolean bl4 = false;
                item$iv$iv = (Result)results.get(it3);
                ((Result)item$iv$iv).setTimes(((Result)item$iv$iv).getTimes() + 1);
            }
        }
        System.out.println((Object)"");
        Iterable $this$forEachIndexed$iv = results;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void it;
            $i$f$forEach = index$iv;
            index$iv = $i$f$forEach + 1;
            if ($i$f$forEach < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            $this$mapTo$iv$iv = (Result)item$iv;
            int i = $i$f$forEach;
            boolean bl = false;
            String times = StringsKt.padStart$default(String.valueOf(it.getTimes()), LootSimulatorKt.length(repetitions) + 1, '\u0000', 2, null);
            float percentage = (float)it.getTimes() / (float)repetitions;
            String index = StringsKt.padStart$default(String.valueOf(i), 5, '\u0000', 2, null);
            String bar = StringsKt.padEnd$default(StringsKt.repeat("%", (int)((float)barSize * percentage)), barSize, '\u0000', 2, null);
            Object[] objectArray = new Object[]{Float.valueOf(percentage * (float)100)};
            String string2 = String.format("%.1f", Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue(string2, "format(this, *args)");
            String chance = StringsKt.padStart$default(string2, 5, '\u0000', 2, null);
            System.out.println((Object)(' ' + index + " [" + bar + "] " + chance + "%  " + times + "   " + it.getLoot()));
        }
        Iterable iterable2 = results;
        String string3 = "Avg item drop: ";
        object = System.out;
        int n4 = 0;
        for (Iterator iterator3 : iterable2) {
            void it;
            Result item$iv = (Result)((Object)iterator3);
            n = n4;
            boolean bl = false;
            int n5 = it.getTimes();
            n4 = n + n5;
        }
        n = n4;
        ((PrintStream)object).println((Object)StringsKt.padStart$default(Intrinsics.stringPlus(string3, Float.valueOf((float)n / (float)repetitions)), 66, '\u0000', 2, null));
    }

    public static /* synthetic */ void main(String[] args2) {
        LootSimulatorKt.main();
    }
}

