/*
 * Decompiled with CFR 0.152.
 */
package org.veiset.kgame.engine.math;

import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.math.Vector3;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.veiset.kgame.engine.input.MouseKt;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000\"\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\u001a&\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0001\u001a\u001e\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u0001\u001a\u0016\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n\u001a\u0016\u0010\f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n\u001a\r\u0010\r\u001a\u00020\u0001*\u00020\nH\u0086\u0002\u001a\r\u0010\u000e\u001a\u00020\u0001*\u00020\nH\u0086\u0002\u001a\n\u0010\u000f\u001a\u00020\n*\u00020\n\u001a\n\u0010\u0010\u001a\u00020\n*\u00020\n\u001a\n\u0010\u0011\u001a\u00020\n*\u00020\n\u001a\u0015\u0010\u0012\u001a\u00020\n*\u00020\n2\u0006\u0010\u0013\u001a\u00020\nH\u0086\u0002\u001a\u001e\u0010\u0014\u001a\u00020\n*\u00020\n2\b\b\u0002\u0010\u0015\u001a\u00020\u00012\b\b\u0002\u0010\u0016\u001a\u00020\u0001\u001a\n\u0010\u0017\u001a\u00020\n*\u00020\n\u001a\u0015\u0010\u0018\u001a\u00020\n*\u00020\n2\u0006\u0010\u0013\u001a\u00020\nH\u0086\u0002\u001a\u0015\u0010\u0019\u001a\u00020\n*\u00020\n2\u0006\u0010\u001a\u001a\u00020\nH\u0086\u0002\u001a\u0015\u0010\u0019\u001a\u00020\n*\u00020\n2\u0006\u0010\u001b\u001a\u00020\u0001H\u0086\u0002\u001a\r\u0010\u001c\u001a\u00020\n*\u00020\nH\u0086\u0002\u001a\n\u0010\u001d\u001a\u00020\n*\u00020\u001e\u001a\u0015\u0010\u0015\u001a\u00020\n*\u00020\u00012\u0006\u0010\u0016\u001a\u00020\u0001H\u0086\u0004\u001a\u0015\u0010\u0015\u001a\u00020\n*\u00020\u001f2\u0006\u0010\u0016\u001a\u00020\u001fH\u0086\u0004\u00a8\u0006 "}, d2={"expLerp", "", "t", "min", "max", "weight", "lerp", "pointerWithinSquare", "", "pos", "Lcom/badlogic/gdx/math/Vector2;", "size", "uiPointerWithinSquare", "component1", "component2", "copy", "dw", "gfxToWorld", "minus", "v", "offset", "x", "y", "perpendicular", "plus", "times", "direction", "scl", "unaryMinus", "v2", "Lcom/badlogic/gdx/math/Vector3;", "", "kgame2"})
public final class Vector2Kt {
    public static final float component1(@NotNull Vector2 $this$component1) {
        Intrinsics.checkNotNullParameter($this$component1, "<this>");
        return $this$component1.x;
    }

    public static final float component2(@NotNull Vector2 $this$component2) {
        Intrinsics.checkNotNullParameter($this$component2, "<this>");
        return $this$component2.y;
    }

    @NotNull
    public static final Vector2 minus(@NotNull Vector2 $this$minus, @NotNull Vector2 v) {
        Intrinsics.checkNotNullParameter($this$minus, "<this>");
        Intrinsics.checkNotNullParameter(v, "v");
        return new Vector2($this$minus.x - v.x, $this$minus.y - v.y);
    }

    @NotNull
    public static final Vector2 plus(@NotNull Vector2 $this$plus, @NotNull Vector2 v) {
        Intrinsics.checkNotNullParameter($this$plus, "<this>");
        Intrinsics.checkNotNullParameter(v, "v");
        return new Vector2($this$plus.x + v.x, $this$plus.y + v.y);
    }

    @NotNull
    public static final Vector2 unaryMinus(@NotNull Vector2 $this$unaryMinus) {
        Intrinsics.checkNotNullParameter($this$unaryMinus, "<this>");
        return new Vector2(-$this$unaryMinus.x, -$this$unaryMinus.y);
    }

    @NotNull
    public static final Vector2 times(@NotNull Vector2 $this$times, @NotNull Vector2 direction) {
        Intrinsics.checkNotNullParameter($this$times, "<this>");
        Intrinsics.checkNotNullParameter(direction, "direction");
        float x = Vector2Kt.component1($this$times);
        float y = Vector2Kt.component2($this$times);
        float dx = Vector2Kt.component1(direction);
        float dy = Vector2Kt.component2(direction);
        return new Vector2(x * dx, y * dy);
    }

    @NotNull
    public static final Vector2 times(@NotNull Vector2 $this$times, float scl) {
        Intrinsics.checkNotNullParameter($this$times, "<this>");
        float x = Vector2Kt.component1($this$times);
        float y = Vector2Kt.component2($this$times);
        return new Vector2(x * scl, y * scl);
    }

    @NotNull
    public static final Vector2 perpendicular(@NotNull Vector2 $this$perpendicular) {
        Intrinsics.checkNotNullParameter($this$perpendicular, "<this>");
        return new Vector2(-$this$perpendicular.y, $this$perpendicular.x);
    }

    @NotNull
    public static final Vector2 copy(@NotNull Vector2 $this$copy) {
        Intrinsics.checkNotNullParameter($this$copy, "<this>");
        return new Vector2($this$copy.x, $this$copy.y);
    }

    @NotNull
    public static final Vector2 dw(@NotNull Vector2 $this$dw) {
        Intrinsics.checkNotNullParameter($this$dw, "<this>");
        return new Vector2($this$dw.x * 120.0f, $this$dw.y * 120.0f);
    }

    @NotNull
    public static final Vector2 gfxToWorld(@NotNull Vector2 $this$gfxToWorld) {
        Intrinsics.checkNotNullParameter($this$gfxToWorld, "<this>");
        return new Vector2($this$gfxToWorld.x / 120.0f, $this$gfxToWorld.y / 120.0f);
    }

    @NotNull
    public static final Vector2 v2(@NotNull Vector3 $this$v2) {
        Intrinsics.checkNotNullParameter($this$v2, "<this>");
        return new Vector2($this$v2.x, $this$v2.y);
    }

    @NotNull
    public static final Vector2 x(float $this$x, float y) {
        return new Vector2($this$x, y);
    }

    @NotNull
    public static final Vector2 x(int $this$x, int y) {
        return new Vector2($this$x, y);
    }

    @NotNull
    public static final Vector2 offset(@NotNull Vector2 $this$offset, float x, float y) {
        Intrinsics.checkNotNullParameter($this$offset, "<this>");
        return Vector2Kt.x($this$offset.x + x, $this$offset.y + y);
    }

    public static /* synthetic */ Vector2 offset$default(Vector2 vector2, float f, float f2, int n, Object object) {
        if ((n & 1) != 0) {
            f = 0.0f;
        }
        if ((n & 2) != 0) {
            f2 = 0.0f;
        }
        return Vector2Kt.offset(vector2, f, f2);
    }

    public static final boolean pointerWithinSquare(@NotNull Vector2 pos, @NotNull Vector2 size) {
        Intrinsics.checkNotNullParameter(pos, "pos");
        Intrinsics.checkNotNullParameter(size, "size");
        Vector2 vector2 = MouseKt.scaledPointer();
        float px = Vector2Kt.component1(vector2);
        float py = Vector2Kt.component2(vector2);
        float x = Vector2Kt.component1(pos);
        float y = Vector2Kt.component2(pos);
        float sx = Vector2Kt.component1(size);
        float sy = Vector2Kt.component2(size);
        return x <= px && x + sx >= px && y <= py && y + sy >= py;
    }

    public static final boolean uiPointerWithinSquare(@NotNull Vector2 pos, @NotNull Vector2 size) {
        Intrinsics.checkNotNullParameter(pos, "pos");
        Intrinsics.checkNotNullParameter(size, "size");
        Vector2 vector2 = MouseKt.uiPointer();
        float px = Vector2Kt.component1(vector2);
        float py = Vector2Kt.component2(vector2);
        float x = Vector2Kt.component1(pos);
        float y = Vector2Kt.component2(pos);
        float sx = Vector2Kt.component1(size);
        float sy = Vector2Kt.component2(size);
        return x <= px && x + sx >= px && y <= py && y + sy >= py;
    }

    public static final float expLerp(float t, float min, float max, float weight) {
        float current = Vector2Kt.lerp(t, min, max);
        float normal = (current - min) / (max - min);
        float exp = (float)Math.pow(normal, weight);
        return exp * (max - min) + min;
    }

    public static final float lerp(float t, float min, float max) {
        return min * (1.0f - t) + max * t;
    }
}

