/*
 * Decompiled with CFR 0.152.
 */
package org.veiset.kgame.engine.sound;

import com.badlogic.gdx.audio.Sound;
import com.badlogic.gdx.graphics.OrthographicCamera;
import com.badlogic.gdx.math.Vector2;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.GlobalScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.veiset.kgame.engine.GameFilesKt;
import org.veiset.kgame.engine.TBEngineKt;
import org.veiset.kgame.engine.sound.LazySound;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J*\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u00152\b\b\u0002\u0010\u0016\u001a\u00020\u00172\b\b\u0002\u0010\u0018\u001a\u00020\u0017J,\u0010\u0019\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00062\b\b\u0002\u0010\u0016\u001a\u00020\u00172\b\b\u0002\u0010\u0018\u001a\u00020\u00172\b\b\u0002\u0010\u001a\u001a\u00020\u0017J\u000e\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u001c\u001a\u00020\u001dJ\u0006\u0010\u001e\u001a\u00020\u0012R\u001c\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001f"}, d2={"Lorg/veiset/kgame/engine/sound/SoundPlayer;", "", "preload", "", "(Z)V", "currentTrack", "Lcom/badlogic/gdx/audio/Sound;", "getCurrentTrack", "()Lcom/badlogic/gdx/audio/Sound;", "setCurrentTrack", "(Lcom/badlogic/gdx/audio/Sound;)V", "currentTrackId", "", "getCurrentTrackId", "()J", "setCurrentTrackId", "(J)V", "playDirectional", "", "effect", "position", "Lcom/badlogic/gdx/math/Vector2;", "volume", "", "pitch", "playEffect", "pan", "playTrack", "soundtrack", "Lorg/veiset/kgame/engine/sound/LazySound;", "stop", "kgame2"})
public final class SoundPlayer {
    @Nullable
    private Sound currentTrack;
    private long currentTrackId;

    public SoundPlayer(boolean preload) {
    }

    public /* synthetic */ SoundPlayer(boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            bl = true;
        }
        this(bl);
    }

    @Nullable
    public final Sound getCurrentTrack() {
        return this.currentTrack;
    }

    public final void setCurrentTrack(@Nullable Sound sound) {
        this.currentTrack = sound;
    }

    public final long getCurrentTrackId() {
        return this.currentTrackId;
    }

    public final void setCurrentTrackId(long l) {
        this.currentTrackId = l;
    }

    public final void playTrack(@NotNull LazySound soundtrack) {
        Intrinsics.checkNotNullParameter(soundtrack, "soundtrack");
        BuildersKt.launch$default(GlobalScope.INSTANCE, null, null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, soundtrack, null){
            int label;
            final /* synthetic */ SoundPlayer this$0;
            final /* synthetic */ LazySound $soundtrack;
            {
                this.this$0 = $receiver;
                this.$soundtrack = $soundtrack;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        long l;
                        ResultKt.throwOnFailure(object);
                        Sound sound = this.this$0.getCurrentTrack();
                        if (sound != null) {
                            sound.stop();
                        }
                        this.this$0.setCurrentTrack(this.$soundtrack.get());
                        Sound sound2 = this.this$0.getCurrentTrack();
                        this.this$0.setCurrentTrackId(sound2 == null ? 0L : (l = sound2.play(GameFilesKt.getGameConfig().getVolumeMusic() * GameFilesKt.getGameConfig().getVolumeMaster())));
                        Sound sound3 = this.this$0.getCurrentTrack();
                        if (sound3 != null) {
                            sound3.setLooping(this.this$0.getCurrentTrackId(), true);
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, 3, null);
    }

    public final void playEffect(@NotNull Sound effect, float volume, float pitch, float pan) {
        Intrinsics.checkNotNullParameter(effect, "effect");
        float vol = GameFilesKt.getGameConfig().getVolumeMaster() * GameFilesKt.getGameConfig().getVolumeEffect() * volume;
        effect.play(vol, pitch, pan);
    }

    public static /* synthetic */ void playEffect$default(SoundPlayer soundPlayer, Sound sound, float f, float f2, float f3, int n, Object object) {
        if ((n & 2) != 0) {
            f = 1.0f;
        }
        if ((n & 4) != 0) {
            f2 = 1.0f;
        }
        if ((n & 8) != 0) {
            f3 = 0.0f;
        }
        soundPlayer.playEffect(sound, f, f2, f3);
    }

    public final void playDirectional(@NotNull Sound effect, @NotNull Vector2 position, float volume, float pitch) {
        Intrinsics.checkNotNullParameter(effect, "effect");
        Intrinsics.checkNotNullParameter(position, "position");
        OrthographicCamera cam = TBEngineKt.getGlobals().getDrawGfx().getCamera();
        float xd = position.x - cam.position.x / 120.0f;
        float pan = xd / 8.0f;
        this.playEffect(effect, volume, pitch, pan);
    }

    public static /* synthetic */ void playDirectional$default(SoundPlayer soundPlayer, Sound sound, Vector2 vector2, float f, float f2, int n, Object object) {
        if ((n & 4) != 0) {
            f = 1.0f;
        }
        if ((n & 8) != 0) {
            f2 = 1.0f;
        }
        soundPlayer.playDirectional(sound, vector2, f, f2);
    }

    public final void stop() {
        Sound sound = this.currentTrack;
        if (sound != null) {
            sound.stop();
        }
    }

    public SoundPlayer() {
        this(false, 1, null);
    }
}

