/*
 * Decompiled with CFR 0.152.
 */
package org.veiset.kgame.engine.state;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.Random;
import kotlin.random.RandomKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.veiset.kgame.engine.GameFilesKt;
import org.veiset.kgame.engine.ecs.core.component.levelselect.GameLevelComponent;
import org.veiset.kgame.engine.math.Hex;
import org.veiset.kgame.engine.math.HexLayout;
import org.veiset.kgame.engine.math.HexagonKt;
import org.veiset.kgame.engine.math.Vector2Kt;
import org.veiset.kgame.engine.state.LevelMonsters;
import org.veiset.kgame.engine.world.BleakForestTiles;
import org.veiset.kgame.engine.world.FireBossTiles;
import org.veiset.kgame.engine.world.HeavyForest;
import org.veiset.kgame.engine.world.MixedForestTiles;
import org.veiset.kgame.engine.world.PureForestTiles;
import org.veiset.kgame.engine.world.WorldMapTileThreshold;
import org.veiset.kgame.game.AtlasGenerator;
import org.veiset.kgame.game.AtlasTile;
import org.veiset.kgame.game.AtlasTileInfo;
import org.veiset.kgame.game.Tileset;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B3\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\b\b\u0002\u0010\t\u001a\u00020\b\u00a2\u0006\u0002\u0010\nJ\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0005H\u00c6\u0003J\u000f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\bH\u00c6\u0003J7\u0010\u0019\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\b\b\u0002\u0010\t\u001a\u00020\bH\u00c6\u0001J\u0013\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001d\u001a\u00020\u001eH\u00d6\u0001J\t\u0010\u001f\u001a\u00020 H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001a\u0010\t\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014\u00a8\u0006!"}, d2={"Lorg/veiset/kgame/engine/state/GameLevelState;", "", "seed", "Lkotlin/random/Random;", "hexLayout", "Lorg/veiset/kgame/engine/math/HexLayout;", "levels", "", "Lorg/veiset/kgame/engine/ecs/core/component/levelselect/GameLevelComponent;", "selectedLevel", "(Lkotlin/random/Random;Lorg/veiset/kgame/engine/math/HexLayout;Ljava/util/List;Lorg/veiset/kgame/engine/ecs/core/component/levelselect/GameLevelComponent;)V", "getHexLayout", "()Lorg/veiset/kgame/engine/math/HexLayout;", "getLevels", "()Ljava/util/List;", "getSeed", "()Lkotlin/random/Random;", "getSelectedLevel", "()Lorg/veiset/kgame/engine/ecs/core/component/levelselect/GameLevelComponent;", "setSelectedLevel", "(Lorg/veiset/kgame/engine/ecs/core/component/levelselect/GameLevelComponent;)V", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "toString", "", "kgame2"})
public final class GameLevelState {
    @NotNull
    private final Random seed;
    @NotNull
    private final HexLayout hexLayout;
    @NotNull
    private final List<GameLevelComponent> levels;
    @NotNull
    private GameLevelComponent selectedLevel;

    public GameLevelState(@NotNull Random seed, @NotNull HexLayout hexLayout, @NotNull List<GameLevelComponent> levels, @NotNull GameLevelComponent selectedLevel) {
        Intrinsics.checkNotNullParameter(seed, "seed");
        Intrinsics.checkNotNullParameter(hexLayout, "hexLayout");
        Intrinsics.checkNotNullParameter(levels, "levels");
        Intrinsics.checkNotNullParameter(selectedLevel, "selectedLevel");
        this.seed = seed;
        this.hexLayout = hexLayout;
        this.levels = levels;
        this.selectedLevel = selectedLevel;
    }

    /*
     * WARNING - void declaration
     */
    public /* synthetic */ GameLevelState(Random random, HexLayout hexLayout, List list, GameLevelComponent gameLevelComponent, int n, DefaultConstructorMarker defaultConstructorMarker) {
        Iterable $this$map$iv;
        if ((n & 1) != 0) {
            random = RandomKt.Random(Random.Default.nextLong());
        }
        if ((n & 2) != 0) {
            hexLayout = new HexLayout(HexagonKt.getLayoutPointy(), Vector2Kt.x(0.6f, 0.6f), Vector2Kt.x(3.0f, 3.0f));
        }
        if ((n & 4) != 0) {
            void $this$mapTo$iv$iv;
            $this$map$iv = new AtlasGenerator(GameFilesKt.getSaveGame(), 0L, 2, null).generateTiles();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                WorldMapTileThreshold worldMapTileThreshold;
                void it;
                AtlasTile atlasTile = (AtlasTile)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                AtlasTileInfo atlasTileInfo = it.getAtlasTileInfo();
                Intrinsics.checkNotNull(atlasTileInfo);
                switch (WhenMappings.$EnumSwitchMapping$0[atlasTileInfo.getTileset().ordinal()]) {
                    case 1: {
                        worldMapTileThreshold = new MixedForestTiles(null, null, 3, null);
                        break;
                    }
                    case 2: {
                        worldMapTileThreshold = new PureForestTiles(null, null, 3, null);
                        break;
                    }
                    case 3: {
                        worldMapTileThreshold = new HeavyForest(null, null, 3, null);
                        break;
                    }
                    case 4: {
                        worldMapTileThreshold = new BleakForestTiles(null, null, 3, null);
                        break;
                    }
                    case 5: {
                        worldMapTileThreshold = new FireBossTiles(null, null, 3, null);
                        break;
                    }
                    case 6: {
                        worldMapTileThreshold = new PureForestTiles(null, null, 3, null);
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                WorldMapTileThreshold tileset = worldMapTileThreshold;
                Hex hex = it.getHex();
                boolean bl2 = it.getAtlasTileInfo().getTileset() == Tileset.StartTile;
                LevelMonsters levelMonsters = it.getAtlasTileInfo().getTileset() == Tileset.Boss ? new LevelMonsters(0, 0, 1) : new LevelMonsters(30 + (int)((float)20 * random.nextFloat()), 1, 0, 4, null);
                long l = random.nextLong();
                collection.add(new GameLevelComponent("Description...", hex, tileset, bl2, levelMonsters, 0, l));
            }
            list = (List)destination$iv$iv;
        }
        if ((n & 8) != 0) {
            void $this$sortedByDescending$iv;
            $this$map$iv = list;
            boolean $i$f$sortedByDescending = false;
            gameLevelComponent = (GameLevelComponent)CollectionsKt.random(CollectionsKt.sortedWith($this$sortedByDescending$iv, new Comparator(){

                public final int compare(T a, T b) {
                    GameLevelComponent it = (GameLevelComponent)b;
                    boolean bl = false;
                    Comparable comparable = Integer.valueOf(it.getRequirement());
                    it = (GameLevelComponent)a;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues(comparable2, it.getRequirement());
                }
            }), random);
        }
        this(random, hexLayout, list, gameLevelComponent);
    }

    @NotNull
    public final Random getSeed() {
        return this.seed;
    }

    @NotNull
    public final HexLayout getHexLayout() {
        return this.hexLayout;
    }

    @NotNull
    public final List<GameLevelComponent> getLevels() {
        return this.levels;
    }

    @NotNull
    public final GameLevelComponent getSelectedLevel() {
        return this.selectedLevel;
    }

    public final void setSelectedLevel(@NotNull GameLevelComponent gameLevelComponent) {
        Intrinsics.checkNotNullParameter(gameLevelComponent, "<set-?>");
        this.selectedLevel = gameLevelComponent;
    }

    @NotNull
    public final Random component1() {
        return this.seed;
    }

    @NotNull
    public final HexLayout component2() {
        return this.hexLayout;
    }

    @NotNull
    public final List<GameLevelComponent> component3() {
        return this.levels;
    }

    @NotNull
    public final GameLevelComponent component4() {
        return this.selectedLevel;
    }

    @NotNull
    public final GameLevelState copy(@NotNull Random seed, @NotNull HexLayout hexLayout, @NotNull List<GameLevelComponent> levels, @NotNull GameLevelComponent selectedLevel) {
        Intrinsics.checkNotNullParameter(seed, "seed");
        Intrinsics.checkNotNullParameter(hexLayout, "hexLayout");
        Intrinsics.checkNotNullParameter(levels, "levels");
        Intrinsics.checkNotNullParameter(selectedLevel, "selectedLevel");
        return new GameLevelState(seed, hexLayout, levels, selectedLevel);
    }

    public static /* synthetic */ GameLevelState copy$default(GameLevelState gameLevelState, Random random, HexLayout hexLayout, List list, GameLevelComponent gameLevelComponent, int n, Object object) {
        if ((n & 1) != 0) {
            random = gameLevelState.seed;
        }
        if ((n & 2) != 0) {
            hexLayout = gameLevelState.hexLayout;
        }
        if ((n & 4) != 0) {
            list = gameLevelState.levels;
        }
        if ((n & 8) != 0) {
            gameLevelComponent = gameLevelState.selectedLevel;
        }
        return gameLevelState.copy(random, hexLayout, list, gameLevelComponent);
    }

    @NotNull
    public String toString() {
        return "GameLevelState(seed=" + this.seed + ", hexLayout=" + this.hexLayout + ", levels=" + this.levels + ", selectedLevel=" + this.selectedLevel + ')';
    }

    public int hashCode() {
        int result2 = this.seed.hashCode();
        result2 = result2 * 31 + this.hexLayout.hashCode();
        result2 = result2 * 31 + ((Object)this.levels).hashCode();
        result2 = result2 * 31 + this.selectedLevel.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof GameLevelState)) {
            return false;
        }
        GameLevelState gameLevelState = (GameLevelState)other;
        if (!Intrinsics.areEqual(this.seed, gameLevelState.seed)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.hexLayout, gameLevelState.hexLayout)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.levels, gameLevelState.levels)) {
            return false;
        }
        return Intrinsics.areEqual(this.selectedLevel, gameLevelState.selectedLevel);
    }

    public GameLevelState() {
        this(null, null, null, null, 15, null);
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Tileset.values().length];
            nArray[Tileset.MixedForestTiles.ordinal()] = 1;
            nArray[Tileset.PureForestTiles.ordinal()] = 2;
            nArray[Tileset.HeavyForest.ordinal()] = 3;
            nArray[Tileset.BleakForestTiles.ordinal()] = 4;
            nArray[Tileset.Boss.ordinal()] = 5;
            nArray[Tileset.StartTile.ordinal()] = 6;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

