/*
 * Decompiled with CFR 0.152.
 */
package org.veiset.kgame.engine.tools.editor.area;

import com.badlogic.ashley.core.Engine;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.physics.box2d.World;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.veiset.kgame.engine.math.Vector2Kt;
import org.veiset.kgame.engine.tools.editor.area.AreaEntity;
import org.veiset.kgame.engine.tools.editor.area.AreaEntityData;
import org.veiset.kgame.engine.tools.editor.area.CollisionEntityData;
import org.veiset.kgame.engine.tools.editor.area.GraphicEntityData;
import org.veiset.kgame.engine.tools.editor.area.components.AreaMetaInfo;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0015\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001BI\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\u0007\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0005\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\t\u0010\u001a\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005H\u00c6\u0003J\t\u0010\u001c\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u001d\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u001e\u001a\u00020\u0007H\u00c6\u0003J\u000f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0005H\u00c6\u0003J\t\u0010 \u001a\u00020\rH\u00c6\u0003J[\u0010!\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\u00072\b\b\u0002\u0010\t\u001a\u00020\u00072\u000e\b\u0002\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00052\b\b\u0002\u0010\f\u001a\u00020\rH\u00c6\u0001J\u0013\u0010\"\u001a\u00020#2\b\u0010$\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\u001e\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010)\u001a\u00020*J\t\u0010+\u001a\u00020,H\u00d6\u0001J\t\u0010-\u001a\u00020\u0003H\u00d6\u0001R\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\t\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0012R\u0011\u0010\b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0012R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0010\u00a8\u0006."}, d2={"Lorg/veiset/kgame/engine/tools/editor/area/AreaData;", "", "name", "", "tags", "", "position", "Lcom/badlogic/gdx/math/Vector2;", "size", "gridsize", "entities", "Lorg/veiset/kgame/engine/tools/editor/area/AreaEntityData;", "metaInfo", "Lorg/veiset/kgame/engine/tools/editor/area/components/AreaMetaInfo;", "(Ljava/lang/String;Ljava/util/List;Lcom/badlogic/gdx/math/Vector2;Lcom/badlogic/gdx/math/Vector2;Lcom/badlogic/gdx/math/Vector2;Ljava/util/List;Lorg/veiset/kgame/engine/tools/editor/area/components/AreaMetaInfo;)V", "getEntities", "()Ljava/util/List;", "getGridsize", "()Lcom/badlogic/gdx/math/Vector2;", "getMetaInfo", "()Lorg/veiset/kgame/engine/tools/editor/area/components/AreaMetaInfo;", "getName", "()Ljava/lang/String;", "getPosition", "getSize", "getTags", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "copy", "equals", "", "other", "generateAt", "", "engine", "Lcom/badlogic/ashley/core/Engine;", "world", "Lcom/badlogic/gdx/physics/box2d/World;", "hashCode", "", "toString", "kgame2"})
public final class AreaData {
    @NotNull
    private final String name;
    @NotNull
    private final List<String> tags;
    @NotNull
    private final Vector2 position;
    @NotNull
    private final Vector2 size;
    @NotNull
    private final Vector2 gridsize;
    @NotNull
    private final List<AreaEntityData> entities;
    @NotNull
    private final AreaMetaInfo metaInfo;

    public AreaData(@NotNull String name, @NotNull List<String> tags, @NotNull Vector2 position, @NotNull Vector2 size, @NotNull Vector2 gridsize, @NotNull List<? extends AreaEntityData> entities2, @NotNull AreaMetaInfo metaInfo) {
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(tags, "tags");
        Intrinsics.checkNotNullParameter(position, "position");
        Intrinsics.checkNotNullParameter(size, "size");
        Intrinsics.checkNotNullParameter(gridsize, "gridsize");
        Intrinsics.checkNotNullParameter(entities2, "entities");
        Intrinsics.checkNotNullParameter(metaInfo, "metaInfo");
        this.name = name;
        this.tags = tags;
        this.position = position;
        this.size = size;
        this.gridsize = gridsize;
        this.entities = entities2;
        this.metaInfo = metaInfo;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final List<String> getTags() {
        return this.tags;
    }

    @NotNull
    public final Vector2 getPosition() {
        return this.position;
    }

    @NotNull
    public final Vector2 getSize() {
        return this.size;
    }

    @NotNull
    public final Vector2 getGridsize() {
        return this.gridsize;
    }

    @NotNull
    public final List<AreaEntityData> getEntities() {
        return this.entities;
    }

    @NotNull
    public final AreaMetaInfo getMetaInfo() {
        return this.metaInfo;
    }

    /*
     * WARNING - void declaration
     */
    public final void generateAt(@NotNull Engine engine, @NotNull Vector2 position, @NotNull World world) {
        void $this$mapTo$iv$iv;
        Object v2;
        Object v1;
        Collection collection;
        void $this$mapTo$iv$iv2;
        Intrinsics.checkNotNullParameter(engine, "engine");
        Intrinsics.checkNotNullParameter(position, "position");
        Intrinsics.checkNotNullParameter(world, "world");
        Iterable $this$map$iv = this.entities;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            Vector2 vector2;
            void it;
            AreaEntityData areaEntityData = (AreaEntityData)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            void var14_36 = it;
            if (var14_36 instanceof CollisionEntityData) {
                vector2 = ((CollisionEntityData)it).getPosition();
            } else if (var14_36 instanceof GraphicEntityData) {
                vector2 = ((GraphicEntityData)it).getPosition();
            } else {
                throw new NoWhenBranchMatchedException();
            }
            collection.add(vector2);
        }
        List positions = (List)destination$iv$iv;
        Iterable $this$minByOrNull$iv = positions;
        boolean $i$f$minByOrNull = false;
        Iterator iterator$iv = $this$minByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v1 = null;
        } else {
            Object minElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v1 = minElem$iv;
            } else {
                Vector2 it = (Vector2)minElem$iv;
                boolean bl = false;
                float minValue$iv = it.x;
                do {
                    Object e$iv = iterator$iv.next();
                    Vector2 it2 = (Vector2)e$iv;
                    $i$a$-minByOrNull-AreaData$generateAt$xPos$1 = false;
                    float v$iv = it2.x;
                    if (Float.compare(minValue$iv, v$iv) <= 0) continue;
                    minElem$iv = e$iv;
                    minValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v1 = minElem$iv;
            }
        }
        Intrinsics.checkNotNull(v1);
        float xPos = ((Vector2)v1).x;
        Iterable $this$minByOrNull$iv2 = positions;
        boolean $i$f$minByOrNull2 = false;
        Iterator iterator$iv2 = $this$minByOrNull$iv2.iterator();
        if (!iterator$iv2.hasNext()) {
            v2 = null;
        } else {
            Object minElem$iv = iterator$iv2.next();
            if (!iterator$iv2.hasNext()) {
                v2 = minElem$iv;
            } else {
                Vector2 it = (Vector2)minElem$iv;
                boolean bl = false;
                float minValue$iv = it.y;
                do {
                    Object e$iv = iterator$iv2.next();
                    Vector2 it3 = (Vector2)e$iv;
                    $i$a$-minByOrNull-AreaData$generateAt$yPos$1 = false;
                    float v$iv = it3.y;
                    if (Float.compare(minValue$iv, v$iv) <= 0) continue;
                    minElem$iv = e$iv;
                    minValue$iv = v$iv;
                } while (iterator$iv2.hasNext());
                v2 = minElem$iv;
            }
        }
        Intrinsics.checkNotNull(v2);
        float yPos = ((Vector2)v2).y;
        Vector2 zpos = Vector2Kt.x(xPos, yPos);
        Iterable $this$map$iv2 = this.entities;
        boolean $i$f$map2 = false;
        Iterable minValue$iv = $this$map$iv2;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv2, 10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            AreaEntity areaEntity;
            void it;
            AreaEntityData areaEntityData = (AreaEntityData)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl = false;
            void var18_45 = it;
            if (var18_45 instanceof CollisionEntityData) {
                areaEntity = ((CollisionEntityData)it).deepCopy(Vector2Kt.minus(Vector2Kt.plus(((CollisionEntityData)it).getPosition(), position), zpos)).toCollisionEntity(world);
            } else if (var18_45 instanceof GraphicEntityData) {
                areaEntity = ((GraphicEntityData)it).deepCopy(Vector2Kt.minus(Vector2Kt.plus(((GraphicEntityData)it).getPosition(), position), zpos)).toGraphicalEntity();
            } else {
                throw new NoWhenBranchMatchedException();
            }
            collection.add(areaEntity);
        }
        List entities2 = (List)destination$iv$iv2;
        Iterable $this$forEach$iv = entities2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AreaEntity it = (AreaEntity)element$iv;
            boolean bl = false;
            engine.addEntity(it.getEntity());
        }
    }

    @NotNull
    public final String component1() {
        return this.name;
    }

    @NotNull
    public final List<String> component2() {
        return this.tags;
    }

    @NotNull
    public final Vector2 component3() {
        return this.position;
    }

    @NotNull
    public final Vector2 component4() {
        return this.size;
    }

    @NotNull
    public final Vector2 component5() {
        return this.gridsize;
    }

    @NotNull
    public final List<AreaEntityData> component6() {
        return this.entities;
    }

    @NotNull
    public final AreaMetaInfo component7() {
        return this.metaInfo;
    }

    @NotNull
    public final AreaData copy(@NotNull String name, @NotNull List<String> tags, @NotNull Vector2 position, @NotNull Vector2 size, @NotNull Vector2 gridsize, @NotNull List<? extends AreaEntityData> entities2, @NotNull AreaMetaInfo metaInfo) {
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(tags, "tags");
        Intrinsics.checkNotNullParameter(position, "position");
        Intrinsics.checkNotNullParameter(size, "size");
        Intrinsics.checkNotNullParameter(gridsize, "gridsize");
        Intrinsics.checkNotNullParameter(entities2, "entities");
        Intrinsics.checkNotNullParameter(metaInfo, "metaInfo");
        return new AreaData(name, tags, position, size, gridsize, entities2, metaInfo);
    }

    public static /* synthetic */ AreaData copy$default(AreaData areaData, String string2, List list, Vector2 vector2, Vector2 vector22, Vector2 vector23, List list2, AreaMetaInfo areaMetaInfo, int n, Object object) {
        if ((n & 1) != 0) {
            string2 = areaData.name;
        }
        if ((n & 2) != 0) {
            list = areaData.tags;
        }
        if ((n & 4) != 0) {
            vector2 = areaData.position;
        }
        if ((n & 8) != 0) {
            vector22 = areaData.size;
        }
        if ((n & 0x10) != 0) {
            vector23 = areaData.gridsize;
        }
        if ((n & 0x20) != 0) {
            list2 = areaData.entities;
        }
        if ((n & 0x40) != 0) {
            areaMetaInfo = areaData.metaInfo;
        }
        return areaData.copy(string2, list, vector2, vector22, vector23, list2, areaMetaInfo);
    }

    @NotNull
    public String toString() {
        return "AreaData(name=" + this.name + ", tags=" + this.tags + ", position=" + this.position + ", size=" + this.size + ", gridsize=" + this.gridsize + ", entities=" + this.entities + ", metaInfo=" + this.metaInfo + ')';
    }

    public int hashCode() {
        int result2 = this.name.hashCode();
        result2 = result2 * 31 + ((Object)this.tags).hashCode();
        result2 = result2 * 31 + this.position.hashCode();
        result2 = result2 * 31 + this.size.hashCode();
        result2 = result2 * 31 + this.gridsize.hashCode();
        result2 = result2 * 31 + ((Object)this.entities).hashCode();
        result2 = result2 * 31 + this.metaInfo.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof AreaData)) {
            return false;
        }
        AreaData areaData = (AreaData)other;
        if (!Intrinsics.areEqual(this.name, areaData.name)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.tags, areaData.tags)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.position, areaData.position)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.size, areaData.size)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.gridsize, areaData.gridsize)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.entities, areaData.entities)) {
            return false;
        }
        return Intrinsics.areEqual(this.metaInfo, areaData.metaInfo);
    }
}

