/*
 * Decompiled with CFR 0.152.
 */
package org.veiset.kgame.engine.tools.editor.area.components;

import com.badlogic.ashley.core.Engine;
import com.badlogic.gdx.math.Vector2;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.veiset.kgame.engine.math.Vector2Kt;
import org.veiset.kgame.engine.tools.editor.area.AreaEntity;
import org.veiset.kgame.engine.tools.editor.area.CollisionEntity;
import org.veiset.kgame.engine.tools.editor.area.EntityType;
import org.veiset.kgame.engine.tools.editor.area.GraphicEntity;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0001\u001dB\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0006J\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005J\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00060\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\u0006\u0010\u0015\u001a\u00020\u0016J\u0010\u0010\u0017\u001a\u00020\u00162\b\b\u0002\u0010\u0018\u001a\u00020\u0019J\u0014\u0010\u001a\u001a\u00020\u000f2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00060\u0012J\u000e\u0010\u001c\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0006R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR \u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\r\u00a8\u0006\u001e"}, d2={"Lorg/veiset/kgame/engine/tools/editor/area/components/SceneContainer;", "", "engine", "Lcom/badlogic/ashley/core/Engine;", "items", "", "Lorg/veiset/kgame/engine/tools/editor/area/AreaEntity;", "(Lcom/badlogic/ashley/core/Engine;Ljava/util/List;)V", "getEngine", "()Lcom/badlogic/ashley/core/Engine;", "getItems", "()Ljava/util/List;", "setItems", "(Ljava/util/List;)V", "add", "", "areaEntity", "areaEntities", "", "type", "Lorg/veiset/kgame/engine/tools/editor/area/EntityType;", "boundingBox", "Lorg/veiset/kgame/engine/tools/editor/area/components/SceneContainer$BoundingBox;", "gridBox", "gridSize", "", "load", "entities", "remove", "BoundingBox", "kgame2"})
public final class SceneContainer {
    @NotNull
    private final Engine engine;
    @NotNull
    private List<AreaEntity> items;

    public SceneContainer(@NotNull Engine engine, @NotNull List<AreaEntity> items) {
        Intrinsics.checkNotNullParameter(engine, "engine");
        Intrinsics.checkNotNullParameter(items, "items");
        this.engine = engine;
        this.items = items;
    }

    @NotNull
    public final Engine getEngine() {
        return this.engine;
    }

    @NotNull
    public final List<AreaEntity> getItems() {
        return this.items;
    }

    public final void setItems(@NotNull List<AreaEntity> list) {
        Intrinsics.checkNotNullParameter(list, "<set-?>");
        this.items = list;
    }

    public final void add(@NotNull AreaEntity areaEntity) {
        Intrinsics.checkNotNullParameter(areaEntity, "areaEntity");
        this.items.add(areaEntity);
        this.engine.addEntity(areaEntity.getEntity());
    }

    public final void remove(@NotNull AreaEntity areaEntity) {
        Intrinsics.checkNotNullParameter(areaEntity, "areaEntity");
        this.items.remove(areaEntity);
        this.engine.removeEntity(areaEntity.getEntity());
    }

    public final void load(@NotNull List<? extends AreaEntity> entities2) {
        AreaEntity p0;
        Intrinsics.checkNotNullParameter(entities2, "entities");
        List<AreaEntity> oldItems = this.items;
        this.items = new ArrayList();
        Iterable $this$forEach$iv = oldItems;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            p0 = (AreaEntity)element$iv;
            boolean bl = false;
            this.remove(p0);
        }
        $this$forEach$iv = entities2;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            p0 = (AreaEntity)element$iv;
            boolean bl = false;
            this.add(p0);
        }
    }

    @NotNull
    public final List<AreaEntity> areaEntities() {
        return this.items;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<AreaEntity> areaEntities(@NotNull EntityType type2) {
        List list;
        Intrinsics.checkNotNullParameter((Object)type2, "type");
        switch (WhenMappings.$EnumSwitchMapping$0[type2.ordinal()]) {
            case 1: {
                void $this$filterIsInstanceTo$iv$iv;
                Iterable $this$filterIsInstance$iv = this.items;
                boolean $i$f$filterIsInstance = false;
                Iterable iterable = $this$filterIsInstance$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterIsInstanceTo = false;
                for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                    if (!(element$iv$iv instanceof GraphicEntity)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                list = (List)destination$iv$iv;
                break;
            }
            case 2: {
                Iterable $this$filterIsInstance$iv = this.items;
                boolean $i$f$filterIsInstance = false;
                Iterable $this$filterIsInstanceTo$iv$iv = $this$filterIsInstance$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterIsInstanceTo = false;
                for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                    if (!(element$iv$iv instanceof CollisionEntity)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                list = (List)destination$iv$iv;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final BoundingBox boundingBox() {
        Iterator $this$mapTo$iv$iv;
        Iterable $this$filterTo$iv$iv;
        Collection collection;
        Object item$iv$iv2;
        void $this$mapTo$iv$iv2;
        AreaEntity it;
        Iterable $this$filterTo$iv$iv2;
        Object element$iv2;
        boolean bl;
        block16: {
            Iterable $this$none$iv = this.items;
            boolean $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv2 : $this$none$iv) {
                    AreaEntity it2 = (AreaEntity)element$iv2;
                    boolean bl2 = false;
                    if (!it2.getBase().getBoundingBox()) continue;
                    bl = false;
                    break block16;
                }
                bl = true;
            }
        }
        if (bl) {
            return new BoundingBox(Vector2Kt.x(0.0f, 0.0f), Vector2Kt.x(0.0f, 0.0f));
        }
        Iterable $this$filter$iv = this.items;
        boolean $i$f$filter = false;
        element$iv2 = $this$filter$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv2) {
            it = (AreaEntity)element$iv$iv;
            boolean bl3 = false;
            if (!it.getBase().getBoundingBox()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv2 = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
            it = (AreaEntity)item$iv$iv2;
            collection = destination$iv$iv;
            boolean bl4 = false;
            Vector2 vector2 = it.getBase().getPosition();
            Vector2 vector22 = Vector2Kt.copy(it.getBase().getSize()).scl(0.5f);
            Intrinsics.checkNotNullExpressionValue(vector22, "it.base.size.copy().scl(0.5f)");
            collection.add(Vector2Kt.minus(vector2, vector22));
        }
        List positions = (List)destination$iv$iv;
        Iterable $this$filter$iv2 = this.items;
        boolean $i$f$filter2 = false;
        destination$iv$iv = $this$filter$iv2;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo2 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            AreaEntity it3 = (AreaEntity)element$iv$iv;
            boolean bl5 = false;
            if (!it3.getBase().getBoundingBox()) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        Iterable $this$map$iv2 = (List)destination$iv$iv2;
        boolean $i$f$map2 = false;
        $this$filterTo$iv$iv = $this$map$iv2;
        destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv2, 10));
        boolean $i$f$mapTo2 = false;
        item$iv$iv2 = $this$mapTo$iv$iv.iterator();
        while (item$iv$iv2.hasNext()) {
            Object item$iv$iv3 = item$iv$iv2.next();
            AreaEntity it3 = (AreaEntity)item$iv$iv3;
            collection = destination$iv$iv2;
            boolean bl6 = false;
            Vector2 vector2 = it3.getBase().getPosition();
            Vector2 vector23 = Vector2Kt.copy(it3.getBase().getSize()).scl(0.5f);
            Intrinsics.checkNotNullExpressionValue(vector23, "it.base.size.copy().scl(0.5f)");
            collection.add(Vector2Kt.plus(vector2, vector23));
        }
        List endPositions = (List)destination$iv$iv2;
        $this$mapTo$iv$iv = ((Iterable)positions).iterator();
        if (!$this$mapTo$iv$iv.hasNext()) {
            throw new NoSuchElementException();
        }
        Vector2 it422 = (Vector2)$this$mapTo$iv$iv.next();
        boolean bl7 = false;
        float it422 = it422.x;
        while ($this$mapTo$iv$iv.hasNext()) {
            Vector2 it32 = (Vector2)$this$mapTo$iv$iv.next();
            $i$a$-minOf-SceneContainer$boundingBox$x$1 = false;
            float it32 = it32.x;
            it422 = Math.min(it422, it32);
        }
        float x = it422;
        Iterator it422 = ((Iterable)positions).iterator();
        if (!it422.hasNext()) {
            throw new NoSuchElementException();
        }
        Vector2 it5 = (Vector2)it422.next();
        boolean bl8 = false;
        float f = it5.y;
        while (it422.hasNext()) {
            Vector2 it22 = (Vector2)it422.next();
            $i$a$-minOf-SceneContainer$boundingBox$y$1 = false;
            float it22 = it22.y;
            f = Math.min(f, it22);
        }
        float y = f;
        Iterator iterator2 = ((Iterable)endPositions).iterator();
        if (!iterator2.hasNext()) {
            throw new NoSuchElementException();
        }
        Vector2 it6 = (Vector2)iterator2.next();
        boolean bl9 = false;
        float f2 = it6.x;
        while (iterator2.hasNext()) {
            Vector2 it522 = (Vector2)iterator2.next();
            $i$a$-maxOf-SceneContainer$boundingBox$xEnd$1 = false;
            float it522 = it522.x;
            f2 = Math.max(f2, it522);
        }
        float xEnd = f2;
        Iterator iterator3 = ((Iterable)endPositions).iterator();
        if (!iterator3.hasNext()) {
            throw new NoSuchElementException();
        }
        Vector2 it7 = (Vector2)iterator3.next();
        boolean bl10 = false;
        float f3 = it7.y;
        while (iterator3.hasNext()) {
            Vector2 it8 = (Vector2)iterator3.next();
            $i$a$-maxOf-SceneContainer$boundingBox$yEnd$1 = false;
            float f4 = it8.y;
            f3 = Math.max(f3, f4);
        }
        float yEnd = f3;
        return new BoundingBox(new Vector2(x, y), new Vector2(xEnd - x, yEnd - y));
    }

    @NotNull
    public final BoundingBox gridBox(float gridSize) {
        BoundingBox boundingBox = this.boundingBox();
        Vector2 size = boundingBox.getSize();
        int gridX = (int)(size.x / gridSize) + 1;
        int gridY = (int)(size.y / gridSize) + 1;
        Vector2 sizeGrid = new Vector2(gridX, gridY);
        Vector2 vector2 = Vector2Kt.copy(sizeGrid).scl(gridSize);
        Intrinsics.checkNotNullExpressionValue(vector2, "sizeGrid.copy().scl(gridSize)");
        Vector2 reminding = Vector2Kt.minus(vector2, boundingBox.getSize());
        Vector2 vector22 = boundingBox.getPos();
        vector2 = reminding.scl(0.5f);
        Intrinsics.checkNotNullExpressionValue(vector2, "reminding.scl(0.5f)");
        return new BoundingBox(Vector2Kt.minus(vector22, vector2), sizeGrid);
    }

    public static /* synthetic */ BoundingBox gridBox$default(SceneContainer sceneContainer, float f, int n, Object object) {
        if ((n & 1) != 0) {
            f = 0.53333336f;
        }
        return sceneContainer.gridBox(f);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0013"}, d2={"Lorg/veiset/kgame/engine/tools/editor/area/components/SceneContainer$BoundingBox;", "", "pos", "Lcom/badlogic/gdx/math/Vector2;", "size", "(Lcom/badlogic/gdx/math/Vector2;Lcom/badlogic/gdx/math/Vector2;)V", "getPos", "()Lcom/badlogic/gdx/math/Vector2;", "getSize", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "kgame2"})
    public static final class BoundingBox {
        @NotNull
        private final Vector2 pos;
        @NotNull
        private final Vector2 size;

        public BoundingBox(@NotNull Vector2 pos, @NotNull Vector2 size) {
            Intrinsics.checkNotNullParameter(pos, "pos");
            Intrinsics.checkNotNullParameter(size, "size");
            this.pos = pos;
            this.size = size;
        }

        @NotNull
        public final Vector2 getPos() {
            return this.pos;
        }

        @NotNull
        public final Vector2 getSize() {
            return this.size;
        }

        @NotNull
        public final Vector2 component1() {
            return this.pos;
        }

        @NotNull
        public final Vector2 component2() {
            return this.size;
        }

        @NotNull
        public final BoundingBox copy(@NotNull Vector2 pos, @NotNull Vector2 size) {
            Intrinsics.checkNotNullParameter(pos, "pos");
            Intrinsics.checkNotNullParameter(size, "size");
            return new BoundingBox(pos, size);
        }

        public static /* synthetic */ BoundingBox copy$default(BoundingBox boundingBox, Vector2 vector2, Vector2 vector22, int n, Object object) {
            if ((n & 1) != 0) {
                vector2 = boundingBox.pos;
            }
            if ((n & 2) != 0) {
                vector22 = boundingBox.size;
            }
            return boundingBox.copy(vector2, vector22);
        }

        @NotNull
        public String toString() {
            return "BoundingBox(pos=" + this.pos + ", size=" + this.size + ')';
        }

        public int hashCode() {
            int result2 = this.pos.hashCode();
            result2 = result2 * 31 + this.size.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof BoundingBox)) {
                return false;
            }
            BoundingBox boundingBox = (BoundingBox)other;
            if (!Intrinsics.areEqual(this.pos, boundingBox.pos)) {
                return false;
            }
            return Intrinsics.areEqual(this.size, boundingBox.size);
        }
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[EntityType.values().length];
            nArray[EntityType.GRAPHICS.ordinal()] = 1;
            nArray[EntityType.COLLISION.ordinal()] = 2;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

