/*
 * Decompiled with CFR 0.152.
 */
package org.veiset.kgame.engine.tools.editor.area.components;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.glutils.ShapeRenderer;
import com.badlogic.gdx.math.Vector2;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import ktx.graphics.ShapeRendererKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.veiset.kgame.engine.TBEngineKt;
import org.veiset.kgame.engine.math.Vector2Kt;
import org.veiset.kgame.engine.tools.editor.area.AreaEntity;
import org.veiset.kgame.engine.tools.editor.area.CollisionEntity;
import org.veiset.kgame.engine.tools.editor.area.EntityType;
import org.veiset.kgame.engine.tools.editor.area.GraphicEntity;
import org.veiset.kgame.engine.tools.editor.area.components.SceneContainer;
import org.veiset.kgame.engine.tools.ui.UiComponentsKt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eJ\u001a\u0010\u000f\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u000eR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\n\u00a8\u0006\u0013"}, d2={"Lorg/veiset/kgame/engine/tools/editor/area/components/SceneEntitySelector;", "", "scene", "Lorg/veiset/kgame/engine/tools/editor/area/components/SceneContainer;", "(Lorg/veiset/kgame/engine/tools/editor/area/components/SceneContainer;)V", "tries", "", "getTries", "()I", "setTries", "(I)V", "drawBoxAroundSelected", "", "areaEntity", "Lorg/veiset/kgame/engine/tools/editor/area/AreaEntity;", "select", "type", "Lorg/veiset/kgame/engine/tools/editor/area/EntityType;", "currentlySelected", "kgame2"})
public final class SceneEntitySelector {
    @NotNull
    private final SceneContainer scene;
    private int tries;

    public SceneEntitySelector(@NotNull SceneContainer scene) {
        Intrinsics.checkNotNullParameter(scene, "scene");
        this.scene = scene;
    }

    public final int getTries() {
        return this.tries;
    }

    public final void setTries(int n) {
        this.tries = n;
    }

    @Nullable
    public final AreaEntity select(@NotNull EntityType type2, @Nullable AreaEntity currentlySelected) {
        AreaEntity it;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Intrinsics.checkNotNullParameter((Object)type2, "type");
        boolean rightClicked = UiComponentsKt.rightClick();
        if (rightClicked) {
            ++this.tries;
        }
        Iterable iterable = this.scene.getItems();
        boolean $i$f$filter = false;
        void var7_7 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            boolean bl;
            it = (AreaEntity)element$iv$iv;
            boolean bl2 = false;
            switch (WhenMappings.$EnumSwitchMapping$0[type2.ordinal()]) {
                case 1: {
                    bl = it instanceof GraphicEntity;
                    break;
                }
                case 2: {
                    bl = it instanceof CollisionEntity;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            if (!bl) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        $i$f$filter = false;
        $this$filterTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Vector2 size;
            it = (AreaEntity)element$iv$iv;
            boolean bl = false;
            Vector2 vector2 = it.getBase().getPosition();
            Vector2 vector22 = Vector2Kt.copy(it.getBase().getSize()).scl(0.5f);
            Intrinsics.checkNotNullExpressionValue(vector22, "it.base.size.copy().scl(0.5f)");
            Vector2 pos = Vector2Kt.minus(vector2, vector22);
            if (!Vector2Kt.pointerWithinSquare(pos, size = it.getBase().getSize())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List selectables = (List)destination$iv$iv;
        if (!rightClicked && CollectionsKt.contains(selectables, currentlySelected)) {
            return currentlySelected;
        }
        int numberOfClicked = selectables.size();
        if (numberOfClicked == 0) {
            return null;
        }
        return (AreaEntity)selectables.get(this.tries % numberOfClicked);
    }

    public final void drawBoxAroundSelected(@Nullable AreaEntity areaEntity) {
        if (areaEntity != null) {
            ShapeRenderer gShapeRenderer = TBEngineKt.getGlobals().getDrawGfx().getShapeRenderer();
            gShapeRenderer.begin(ShapeRenderer.ShapeType.Line);
            gShapeRenderer.setColor(Color.RED);
            Vector2 vector2 = areaEntity.getBase().getPosition();
            Vector2 vector22 = Vector2Kt.copy(areaEntity.getBase().getSize()).scl(0.5f);
            Intrinsics.checkNotNullExpressionValue(vector22, "areaEntity.base.size.copy().scl(0.5f)");
            ShapeRendererKt.rect(gShapeRenderer, Vector2Kt.dw(Vector2Kt.minus(vector2, vector22)), Vector2Kt.dw(areaEntity.getBase().getSize()));
            gShapeRenderer.end();
        }
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[EntityType.values().length];
            nArray[EntityType.GRAPHICS.ordinal()] = 1;
            nArray[EntityType.COLLISION.ordinal()] = 2;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

