/*
 * Decompiled with CFR 0.152.
 */
package org.veiset.kgame.engine.tools.ui.components;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.glutils.ShapeRenderer;
import com.badlogic.gdx.math.Vector2;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import ktx.graphics.ShapeRendererKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.veiset.kgame.engine.math.Vector2Kt;
import org.veiset.kgame.engine.tools.ui.UiComponent;
import org.veiset.kgame.engine.tools.ui.UiComponentsKt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0010\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\b\u0086\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\t\u0010\u0017\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u0006H\u00c6\u0003J'\u0010\u001a\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\b\u0010\u001b\u001a\u00020\u001cH\u0016J\u0013\u0010\u001d\u001a\u00020\u000b2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u00d6\u0003J\t\u0010 \u001a\u00020!H\u00d6\u0001J\u0006\u0010\"\u001a\u00020\u000bJ\t\u0010#\u001a\u00020\u0006H\u00d6\u0001J\b\u0010$\u001a\u00020\u001cH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\tR\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0015\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\t\u00a8\u0006%"}, d2={"Lorg/veiset/kgame/engine/tools/ui/components/InputField;", "Lorg/veiset/kgame/engine/tools/ui/UiComponent;", "position", "Lcom/badlogic/gdx/math/Vector2;", "size", "text", "", "(Lcom/badlogic/gdx/math/Vector2;Lcom/badlogic/gdx/math/Vector2;Ljava/lang/String;)V", "getPosition", "()Lcom/badlogic/gdx/math/Vector2;", "selected", "", "getSelected", "()Z", "setSelected", "(Z)V", "getSize", "getText", "()Ljava/lang/String;", "setText", "(Ljava/lang/String;)V", "tp", "getTp", "component1", "component2", "component3", "copy", "draw", "", "equals", "other", "", "hashCode", "", "hovered", "toString", "update", "kgame2"})
public final class InputField
implements UiComponent {
    @NotNull
    private final Vector2 position;
    @NotNull
    private final Vector2 size;
    @NotNull
    private String text;
    private boolean selected;
    @NotNull
    private final Vector2 tp;

    public InputField(@NotNull Vector2 position, @NotNull Vector2 size, @NotNull String text) {
        Intrinsics.checkNotNullParameter(position, "position");
        Intrinsics.checkNotNullParameter(size, "size");
        Intrinsics.checkNotNullParameter(text, "text");
        this.position = position;
        this.size = size;
        this.text = text;
        this.tp = Vector2Kt.dw(Vector2Kt.plus(this.position, new Vector2(0.1f, this.size.y * 0.5f + 0.05f)));
    }

    public /* synthetic */ InputField(Vector2 vector2, Vector2 vector22, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            string2 = "";
        }
        this(vector2, vector22, string2);
    }

    @NotNull
    public final Vector2 getPosition() {
        return this.position;
    }

    @NotNull
    public final Vector2 getSize() {
        return this.size;
    }

    @NotNull
    public final String getText() {
        return this.text;
    }

    public final void setText(@NotNull String string2) {
        Intrinsics.checkNotNullParameter(string2, "<set-?>");
        this.text = string2;
    }

    public final boolean getSelected() {
        return this.selected;
    }

    public final void setSelected(boolean bl) {
        this.selected = bl;
    }

    @NotNull
    public final Vector2 getTp() {
        return this.tp;
    }

    @Override
    public void draw() {
        Color selectedColor = this.selected ? Color.WHITE : Color.DARK_GRAY;
        UiComponentsKt.getShapeRenderer().begin(ShapeRenderer.ShapeType.Filled);
        UiComponentsKt.getShapeRenderer().setColor(Color.BLACK);
        ShapeRendererKt.rect(UiComponentsKt.getShapeRenderer(), Vector2Kt.dw(this.position), Vector2Kt.dw(this.size));
        UiComponentsKt.getShapeRenderer().end();
        UiComponentsKt.getShapeRenderer().begin(ShapeRenderer.ShapeType.Line);
        UiComponentsKt.getShapeRenderer().setColor(selectedColor);
        ShapeRendererKt.rect(UiComponentsKt.getShapeRenderer(), Vector2Kt.dw(this.position), Vector2Kt.dw(this.size));
        UiComponentsKt.getShapeRenderer().end();
        UiComponentsKt.getSpriteBatch().begin();
        UiComponentsKt.getFont().setColor(selectedColor);
        UiComponentsKt.getFont().draw((Batch)UiComponentsKt.getSpriteBatch(), this.text, this.tp.x, this.tp.y);
        UiComponentsKt.getSpriteBatch().end();
    }

    @Override
    public void update() {
        if (Gdx.input.isButtonJustPressed(0)) {
            this.selected = Vector2Kt.uiPointerWithinSquare(this.position, this.size);
        }
        if (Gdx.input.isKeyJustPressed(111)) {
            this.selected = false;
        }
    }

    public final boolean hovered() {
        return Vector2Kt.uiPointerWithinSquare(this.position, this.size);
    }

    @NotNull
    public final Vector2 component1() {
        return this.position;
    }

    @NotNull
    public final Vector2 component2() {
        return this.size;
    }

    @NotNull
    public final String component3() {
        return this.text;
    }

    @NotNull
    public final InputField copy(@NotNull Vector2 position, @NotNull Vector2 size, @NotNull String text) {
        Intrinsics.checkNotNullParameter(position, "position");
        Intrinsics.checkNotNullParameter(size, "size");
        Intrinsics.checkNotNullParameter(text, "text");
        return new InputField(position, size, text);
    }

    public static /* synthetic */ InputField copy$default(InputField inputField, Vector2 vector2, Vector2 vector22, String string2, int n, Object object) {
        if ((n & 1) != 0) {
            vector2 = inputField.position;
        }
        if ((n & 2) != 0) {
            vector22 = inputField.size;
        }
        if ((n & 4) != 0) {
            string2 = inputField.text;
        }
        return inputField.copy(vector2, vector22, string2);
    }

    @NotNull
    public String toString() {
        return "InputField(position=" + this.position + ", size=" + this.size + ", text=" + this.text + ')';
    }

    public int hashCode() {
        int result2 = this.position.hashCode();
        result2 = result2 * 31 + this.size.hashCode();
        result2 = result2 * 31 + this.text.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof InputField)) {
            return false;
        }
        InputField inputField = (InputField)other;
        if (!Intrinsics.areEqual(this.position, inputField.position)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.size, inputField.size)) {
            return false;
        }
        return Intrinsics.areEqual(this.text, inputField.text);
    }
}

