/*
 * Decompiled with CFR 0.152.
 */
package org.veiset.kgame.engine.ui;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.math.Vector2;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.MatchGroup;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.veiset.kgame.engine.math.Vector2Kt;
import org.veiset.kgame.engine.ui.ModifierText;
import org.veiset.kgame.engine.util.FontUtilsKt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0002\b\n\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\b\u0018\u0000 -2\u00020\u0001:\u0003-./B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\t\u0010\u0018\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u001b\u001a\u00020\tH\u00c6\u0003J1\u0010\u001c\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\tH\u00c6\u0001J\u001e\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\tJ\u0013\u0010$\u001a\u00020%2\b\u0010&\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010'\u001a\u00020\u0007H\u00d6\u0001J\u001e\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00050\u00142\u0006\u0010(\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\t\u0010)\u001a\u00020\u0005H\u00d6\u0001J*\u0010*\u001a\u00020\u001e*\u00020\u00032\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u001f\u001a\u00020 2\f\u0010+\u001a\b\u0012\u0004\u0012\u00020,0\u0014H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u00060"}, d2={"Lorg/veiset/kgame/engine/ui/ModifierText;", "", "font", "Lcom/badlogic/gdx/graphics/g2d/BitmapFont;", "string", "", "maxLength", "", "ypadding", "", "(Lcom/badlogic/gdx/graphics/g2d/BitmapFont;Ljava/lang/String;IF)V", "getFont", "()Lcom/badlogic/gdx/graphics/g2d/BitmapFont;", "lines", "getLines", "()I", "getMaxLength", "getString", "()Ljava/lang/String;", "textLines", "", "Lorg/veiset/kgame/engine/ui/ModifierText$TextLine;", "getYpadding", "()F", "component1", "component2", "component3", "component4", "copy", "draw", "", "sb", "Lcom/badlogic/gdx/graphics/g2d/SpriteBatch;", "position", "Lcom/badlogic/gdx/math/Vector2;", "width", "equals", "", "other", "hashCode", "description", "toString", "drawTokenizedText", "tokens", "Lorg/veiset/kgame/engine/ui/ModifierText$TextToken;", "Companion", "TextLine", "TextToken", "kgame2"})
public final class ModifierText {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final BitmapFont font;
    @NotNull
    private final String string;
    private final int maxLength;
    private final float ypadding;
    @NotNull
    private final List<TextLine> textLines;
    private final int lines;
    @NotNull
    private static final String endOfGroup = "(?=$|\\s|[a-zA-Z]|,)";
    @NotNull
    private static final Regex tokenRegex = new Regex(Intrinsics.stringPlus("\\[(.+?)\\]\\((.+?)\\)", endOfGroup));

    /*
     * WARNING - void declaration
     */
    public ModifierText(@NotNull BitmapFont font, @NotNull String string2, int maxLength, float ypadding) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(font, "font");
        Intrinsics.checkNotNullParameter(string2, "string");
        this.font = font;
        this.string = string2;
        this.maxLength = maxLength;
        this.ypadding = ypadding;
        Iterable iterable = this.textLines(this.string, this.maxLength);
        ModifierText modifierText = this;
        boolean $i$f$map = false;
        void var7_8 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string3 = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new TextLine((String)it));
        }
        modifierText.textLines = (List)destination$iv$iv;
        this.lines = this.textLines.size();
    }

    @NotNull
    public final BitmapFont getFont() {
        return this.font;
    }

    @NotNull
    public final String getString() {
        return this.string;
    }

    public final int getMaxLength() {
        return this.maxLength;
    }

    public final float getYpadding() {
        return this.ypadding;
    }

    public final int getLines() {
        return this.lines;
    }

    /*
     * WARNING - void declaration
     */
    public final void draw(@NotNull SpriteBatch sb, @NotNull Vector2 position, float width) {
        Intrinsics.checkNotNullParameter(sb, "sb");
        Intrinsics.checkNotNullParameter(position, "position");
        sb.begin();
        Iterable $this$forEachIndexed$iv = this.textLines;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void line;
            int n = index$iv;
            index$iv = n + 1;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            TextLine textLine = (TextLine)item$iv;
            int index = n;
            boolean bl = false;
            List<TextToken> parts = line.getParts();
            String string2 = line.getString();
            float textX = FontUtilsKt.middleX(this.getFont(), ((Object)StringsKt.trim((CharSequence)string2)).toString(), position.x, position.x + width);
            Vector2 textPos = Vector2Kt.dw(Vector2Kt.plus(position, Vector2Kt.x(textX, (float)(-index) * this.getYpadding())));
            this.drawTokenizedText(this.getFont(), textPos, sb, parts);
        }
        sb.end();
    }

    private final void drawTokenizedText(BitmapFont $this$drawTokenizedText, Vector2 position, SpriteBatch sb, List<TextToken> tokens) {
        float x = Vector2Kt.component1(position);
        float y = Vector2Kt.component2(position);
        float xPos = 0.0f;
        xPos = x;
        Iterable $this$forEach$iv = tokens;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TextToken it = (TextToken)element$iv;
            boolean bl = false;
            String string2 = it.getToken();
            if (Intrinsics.areEqual(string2, "GOOD")) {
                $this$drawTokenizedText.setColor(Color.GREEN);
            } else if (Intrinsics.areEqual(string2, "BAD")) {
                $this$drawTokenizedText.setColor(Color.RED);
            } else {
                $this$drawTokenizedText.setColor(Color.WHITE);
            }
            $this$drawTokenizedText.draw((Batch)sb, it.getText(), xPos, y);
            xPos += FontUtilsKt.sizeX($this$drawTokenizedText, it.getText()) * 120.0f;
        }
    }

    private final List<String> textLines(String description2, int maxLength) {
        String[] stringArray = new String[]{" "};
        List s = StringsKt.split$default((CharSequence)description2, stringArray, false, 0, 6, null);
        String currentLine = null;
        currentLine = "";
        List lines = new ArrayList();
        int length = 0;
        Iterable $this$forEach$iv = s;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            int wordLength;
            int n;
            String word = (String)element$iv;
            boolean bl = false;
            MatchResult w = Regex.find$default(tokenRegex, word, 0, 2, null);
            if (w != null) {
                MatchGroup matchGroup = w.getGroups().get(2);
                Intrinsics.checkNotNull(matchGroup);
                n = matchGroup.getValue().length();
            } else {
                n = wordLength = word.length();
            }
            if (length + wordLength + 1 <= maxLength) {
                length += wordLength + 1;
                currentLine = currentLine + word + ' ';
                continue;
            }
            lines.add(currentLine);
            length = wordLength + 1;
            currentLine = Intrinsics.stringPlus(word, " ");
        }
        lines.add(currentLine);
        return lines;
    }

    @NotNull
    public final BitmapFont component1() {
        return this.font;
    }

    @NotNull
    public final String component2() {
        return this.string;
    }

    public final int component3() {
        return this.maxLength;
    }

    public final float component4() {
        return this.ypadding;
    }

    @NotNull
    public final ModifierText copy(@NotNull BitmapFont font, @NotNull String string2, int maxLength, float ypadding) {
        Intrinsics.checkNotNullParameter(font, "font");
        Intrinsics.checkNotNullParameter(string2, "string");
        return new ModifierText(font, string2, maxLength, ypadding);
    }

    public static /* synthetic */ ModifierText copy$default(ModifierText modifierText, BitmapFont bitmapFont, String string2, int n, float f, int n2, Object object) {
        if ((n2 & 1) != 0) {
            bitmapFont = modifierText.font;
        }
        if ((n2 & 2) != 0) {
            string2 = modifierText.string;
        }
        if ((n2 & 4) != 0) {
            n = modifierText.maxLength;
        }
        if ((n2 & 8) != 0) {
            f = modifierText.ypadding;
        }
        return modifierText.copy(bitmapFont, string2, n, f);
    }

    @NotNull
    public String toString() {
        return "ModifierText(font=" + this.font + ", string=" + this.string + ", maxLength=" + this.maxLength + ", ypadding=" + this.ypadding + ')';
    }

    public int hashCode() {
        int result2 = this.font.hashCode();
        result2 = result2 * 31 + this.string.hashCode();
        result2 = result2 * 31 + Integer.hashCode(this.maxLength);
        result2 = result2 * 31 + Float.hashCode(this.ypadding);
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ModifierText)) {
            return false;
        }
        ModifierText modifierText = (ModifierText)other;
        if (!Intrinsics.areEqual(this.font, modifierText.font)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.string, modifierText.string)) {
            return false;
        }
        if (this.maxLength != modifierText.maxLength) {
            return false;
        }
        return Intrinsics.areEqual((Object)Float.valueOf(this.ypadding), (Object)Float.valueOf(modifierText.ypadding));
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\u000f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0003H\u00d6\u0001J\u0012\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006*\u00020\u0003H\u0002R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000b\u00a8\u0006\u0017"}, d2={"Lorg/veiset/kgame/engine/ui/ModifierText$TextLine;", "", "rawString", "", "(Ljava/lang/String;)V", "parts", "", "Lorg/veiset/kgame/engine/ui/ModifierText$TextToken;", "getParts", "()Ljava/util/List;", "getRawString", "()Ljava/lang/String;", "string", "getString", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "tokenize", "kgame2"})
    public static final class TextLine {
        @NotNull
        private final String rawString;
        @NotNull
        private final List<TextToken> parts;
        @NotNull
        private final String string;

        public TextLine(@NotNull String rawString) {
            Intrinsics.checkNotNullParameter(rawString, "rawString");
            this.rawString = rawString;
            this.parts = this.tokenize(this.rawString);
            this.string = CollectionsKt.joinToString$default(this.parts, "", null, null, 0, null, string.1.INSTANCE, 30, null);
        }

        @NotNull
        public final String getRawString() {
            return this.rawString;
        }

        /*
         * WARNING - void declaration
         */
        private final List<TextToken> tokenize(String $this$tokenize) {
            void $this$mapTo$iv$iv;
            Iterable $this$filterTo$iv$iv;
            Collection<TextToken> collection;
            List list;
            Sequence tokens = Regex.findAll$default(tokenRegex, $this$tokenize, 0, 2, null);
            boolean bl = false;
            Iterable $this$zipWithNext$iv = CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.listOf(0), SequencesKt.flatMapIterable(tokens, tokenize.1.1.INSTANCE)), (Iterable)CollectionsKt.listOf($this$tokenize.length()));
            boolean $i$f$zipWithNext = false;
            Iterator iterator$iv = $this$zipWithNext$iv.iterator();
            if (!iterator$iv.hasNext()) {
                list = CollectionsKt.emptyList();
            } else {
                List result$iv = new ArrayList();
                Object current$iv = iterator$iv.next();
                while (iterator$iv.hasNext()) {
                    void end;
                    void start;
                    Object next$iv = iterator$iv.next();
                    int n = ((Number)next$iv).intValue();
                    int n2 = ((Number)current$iv).intValue();
                    collection = result$iv;
                    boolean bl2 = false;
                    String string2 = $this$tokenize.substring((int)start, (int)end);
                    Intrinsics.checkNotNullExpressionValue(string2, "this as java.lang.String\u2026ing(startIndex, endIndex)");
                    collection.add((TextToken)((Object)string2));
                    current$iv = next$iv;
                }
                list = result$iv;
            }
            Iterable $this$filter$iv = list;
            boolean $i$f$filter = false;
            iterator$iv = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                String it = (String)element$iv$iv;
                boolean bl3 = false;
                boolean bl4 = ((CharSequence)it).length() > 0;
                if (!bl4) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                TextToken textToken;
                String it = (String)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl5 = false;
                MatchResult match = Regex.find$default(tokenRegex, it, 0, 2, null);
                if (match == null) {
                    textToken = new TextToken(it, null);
                } else {
                    MatchGroup matchGroup = match.getGroups().get(2);
                    Intrinsics.checkNotNull(matchGroup);
                    String string3 = matchGroup.getValue();
                    MatchGroup matchGroup2 = match.getGroups().get(1);
                    Intrinsics.checkNotNull(matchGroup2);
                    textToken = new TextToken(string3, matchGroup2.getValue());
                }
                collection.add(textToken);
            }
            return (List)destination$iv$iv;
        }

        @NotNull
        public final List<TextToken> getParts() {
            return this.parts;
        }

        @NotNull
        public final String getString() {
            return this.string;
        }

        @NotNull
        public final String component1() {
            return this.rawString;
        }

        @NotNull
        public final TextLine copy(@NotNull String rawString) {
            Intrinsics.checkNotNullParameter(rawString, "rawString");
            return new TextLine(rawString);
        }

        public static /* synthetic */ TextLine copy$default(TextLine textLine, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                string2 = textLine.rawString;
            }
            return textLine.copy(string2);
        }

        @NotNull
        public String toString() {
            return "TextLine(rawString=" + this.rawString + ')';
        }

        public int hashCode() {
            return this.rawString.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof TextLine)) {
                return false;
            }
            TextLine textLine = (TextLine)other;
            return Intrinsics.areEqual(this.rawString, textLine.rawString);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\n\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u001f\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lorg/veiset/kgame/engine/ui/ModifierText$TextToken;", "", "text", "", "token", "(Ljava/lang/String;Ljava/lang/String;)V", "getText", "()Ljava/lang/String;", "getToken", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "kgame2"})
    public static final class TextToken {
        @NotNull
        private final String text;
        @Nullable
        private final String token;

        public TextToken(@NotNull String text, @Nullable String token) {
            Intrinsics.checkNotNullParameter(text, "text");
            this.text = text;
            this.token = token;
        }

        @NotNull
        public final String getText() {
            return this.text;
        }

        @Nullable
        public final String getToken() {
            return this.token;
        }

        @NotNull
        public final String component1() {
            return this.text;
        }

        @Nullable
        public final String component2() {
            return this.token;
        }

        @NotNull
        public final TextToken copy(@NotNull String text, @Nullable String token) {
            Intrinsics.checkNotNullParameter(text, "text");
            return new TextToken(text, token);
        }

        public static /* synthetic */ TextToken copy$default(TextToken textToken, String string2, String string3, int n, Object object) {
            if ((n & 1) != 0) {
                string2 = textToken.text;
            }
            if ((n & 2) != 0) {
                string3 = textToken.token;
            }
            return textToken.copy(string2, string3);
        }

        @NotNull
        public String toString() {
            return "TextToken(text=" + this.text + ", token=" + this.token + ')';
        }

        public int hashCode() {
            int result2 = this.text.hashCode();
            result2 = result2 * 31 + (this.token == null ? 0 : this.token.hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof TextToken)) {
                return false;
            }
            TextToken textToken = (TextToken)other;
            if (!Intrinsics.areEqual(this.text, textToken.text)) {
                return false;
            }
            return Intrinsics.areEqual(this.token, textToken.token);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/veiset/kgame/engine/ui/ModifierText$Companion;", "", "()V", "endOfGroup", "", "tokenRegex", "Lkotlin/text/Regex;", "kgame2"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

