/*
 * Decompiled with CFR 0.152.
 */
package org.veiset.kgame.engine.ui.component;

import com.badlogic.gdx.InputAdapter;
import com.badlogic.gdx.audio.Sound;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.math.Vector2;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.veiset.kgame.engine.GameFilesKt;
import org.veiset.kgame.engine.Log;
import org.veiset.kgame.engine.TBEngineKt;
import org.veiset.kgame.engine.asset.AssetManager;
import org.veiset.kgame.engine.asset.AssetRef;
import org.veiset.kgame.engine.input.MouseKt;
import org.veiset.kgame.engine.math.Vector2Kt;
import org.veiset.kgame.engine.sound.SoundPlayer;
import org.veiset.kgame.engine.ui.component.UIComponent;
import org.veiset.kgame.engine.ui.component.UISliderKt;
import org.veiset.kgame.engine.values.Asset;
import org.veiset.kgame.presentation.PPresentationKt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u001d\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0086\b\u0018\u0000 <2\u00020\u00012\u00020\u0002:\u0001<BD\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0004\u0012#\b\u0002\u0010\b\u001a\u001d\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\n\u0012\b\b\u000b\u0012\u0004\b\b(\u0003\u0012\u0004\u0012\u00020\f0\t\u00a2\u0006\u0002\u0010\rJ\t\u0010$\u001a\u00020\u0004H\u00c6\u0003J\t\u0010%\u001a\u00020\u0006H\u00c6\u0003J\t\u0010&\u001a\u00020\u0004H\u00c6\u0003J$\u0010'\u001a\u001d\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\n\u0012\b\b\u000b\u0012\u0004\b\b(\u0003\u0012\u0004\u0012\u00020\f0\tH\u00c6\u0003JL\u0010(\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\u00042#\b\u0002\u0010\b\u001a\u001d\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\n\u0012\b\b\u000b\u0012\u0004\b\b(\u0003\u0012\u0004\u0012\u00020\f0\tH\u00c6\u0001J\u0010\u0010)\u001a\u00020\f2\u0006\u0010*\u001a\u00020\u0004H\u0016J\u0013\u0010+\u001a\u00020\u000f2\b\u0010,\u001a\u0004\u0018\u00010-H\u00d6\u0003J\b\u0010.\u001a\u00020\fH\u0002J\t\u0010/\u001a\u000200H\u00d6\u0001J\b\u00101\u001a\u00020\u000fH\u0002J\u0018\u00102\u001a\u00020\u000f2\u0006\u00103\u001a\u0002002\u0006\u00104\u001a\u000200H\u0016J\t\u00105\u001a\u000206H\u00d6\u0001J(\u00107\u001a\u00020\u000f2\u0006\u00103\u001a\u0002002\u0006\u00104\u001a\u0002002\u0006\u00108\u001a\u0002002\u0006\u00109\u001a\u000200H\u0016J \u0010:\u001a\u00020\u000f2\u0006\u00103\u001a\u0002002\u0006\u00104\u001a\u0002002\u0006\u00108\u001a\u000200H\u0016J(\u0010;\u001a\u00020\u000f2\u0006\u00103\u001a\u0002002\u0006\u00104\u001a\u0002002\u0006\u00108\u001a\u0002002\u0006\u00109\u001a\u000200H\u0016R\u001a\u0010\u000e\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R,\u0010\b\u001a\u001d\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\n\u0012\b\b\u000b\u0012\u0004\b\b(\u0003\u0012\u0004\u0012\u00020\f0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0016\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0019\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u0011\"\u0004\b\u001b\u0010\u0013R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010\u001f\"\u0004\b!\u0010\"R\u000e\u0010#\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006="}, d2={"Lorg/veiset/kgame/engine/ui/component/UISlider;", "Lorg/veiset/kgame/engine/ui/component/UIComponent;", "Lcom/badlogic/gdx/InputAdapter;", "value", "", "position", "Lcom/badlogic/gdx/math/Vector2;", "scale", "f", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "", "(FLcom/badlogic/gdx/math/Vector2;FLkotlin/jvm/functions/Function1;)V", "dragging", "", "getDragging", "()Z", "setDragging", "(Z)V", "getF", "()Lkotlin/jvm/functions/Function1;", "handleHeight", "handleWidth", "height", "hovering", "getHovering", "setHovering", "getPosition", "()Lcom/badlogic/gdx/math/Vector2;", "getScale", "()F", "getValue", "setValue", "(F)V", "width", "component1", "component2", "component3", "component4", "copy", "draw", "delta", "equals", "other", "", "handleMove", "hashCode", "", "hovered", "mouseMoved", "screenX", "screenY", "toString", "", "touchDown", "pointer", "button", "touchDragged", "touchUp", "Companion", "kgame2"})
public final class UISlider
extends InputAdapter
implements UIComponent {
    @NotNull
    public static final Companion Companion;
    private float value;
    @NotNull
    private final Vector2 position;
    private final float scale;
    @NotNull
    private final Function1<Float, Unit> f;
    private final float handleWidth;
    private final float handleHeight;
    private final float width;
    private final float height;
    private boolean dragging;
    private boolean hovering;
    @NotNull
    private static final BitmapFont font;
    @NotNull
    private static final TextureRegion usedBar;
    @NotNull
    private static final TextureRegion unusedBar;
    @NotNull
    private static final TextureRegion handle;
    @NotNull
    private static final TextureRegion handleHovered;
    @NotNull
    private static final Sound hoverSound;

    public UISlider(float value, @NotNull Vector2 position, float scale, @NotNull Function1<? super Float, Unit> f) {
        Intrinsics.checkNotNullParameter(position, "position");
        Intrinsics.checkNotNullParameter(f, "f");
        this.value = value;
        this.position = position;
        this.scale = scale;
        this.f = f;
        this.handleWidth = (float)handle.getRegionWidth() * this.scale;
        this.handleHeight = (float)handle.getRegionHeight() * this.scale;
        this.width = (float)usedBar.getRegionWidth() * this.scale;
        this.height = (float)usedBar.getRegionHeight() * this.scale;
    }

    public /* synthetic */ UISlider(float f, Vector2 vector2, float f2, Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            f2 = 3.0f;
        }
        if ((n & 8) != 0) {
            function1 = 1.INSTANCE;
        }
        this(f, vector2, f2, function1);
    }

    public final float getValue() {
        return this.value;
    }

    public final void setValue(float f) {
        this.value = f;
    }

    @NotNull
    public final Vector2 getPosition() {
        return this.position;
    }

    public final float getScale() {
        return this.scale;
    }

    @NotNull
    public final Function1<Float, Unit> getF() {
        return this.f;
    }

    public final boolean getDragging() {
        return this.dragging;
    }

    public final void setDragging(boolean bl) {
        this.dragging = bl;
    }

    public final boolean getHovering() {
        return this.hovering;
    }

    public final void setHovering(boolean bl) {
        this.hovering = bl;
    }

    @Override
    public void draw(float delta) {
        SpriteBatch sb = TBEngineKt.getGlobals().getDrawUi().getSpriteBatch();
        Vector2 vector2 = Vector2Kt.dw(this.position);
        float x = Vector2Kt.component1(vector2);
        float y = Vector2Kt.component2(vector2);
        sb.begin();
        sb.draw(usedBar, x, y, this.width * this.value, this.height);
        sb.draw(unusedBar, x + this.width * this.value, y, this.width * (1.0f - this.value), this.height);
        TextureRegion gfx = this.hovering || this.dragging ? handleHovered : handle;
        float handleX = x + this.width * this.value - this.handleWidth / 2.0f;
        sb.draw(gfx, handleX, y - this.handleHeight / 4.0f, this.handleWidth, this.handleHeight);
        sb.end();
    }

    private final boolean hovered() {
        float hheight = this.handleHeight / 120.0f;
        Vector2 size = Vector2Kt.gfxToWorld(Vector2Kt.x(this.width + this.handleWidth, this.handleHeight));
        return Vector2Kt.uiPointerWithinSquare(Vector2Kt.minus(this.position, Vector2Kt.x(this.handleWidth / 2.0f / 120.0f, hheight / 4.0f)), size);
    }

    private final void handleMove() {
    }

    @Override
    public boolean mouseMoved(int screenX, int screenY) {
        boolean hoveringState = this.hovered();
        if (!this.hovering && hoveringState) {
            SoundPlayer.playEffect$default(TBEngineKt.getGlobals().getSoundPlayer(), hoverSound, GameFilesKt.getGameConfig().getVolumeUi(), 0.0f, 0.0f, 12, null);
        }
        this.hovering = hoveringState;
        this.handleMove();
        return false;
    }

    @Override
    public boolean touchDragged(int screenX, int screenY, int pointer) {
        if (this.dragging) {
            float x = MouseKt.uiPointer().x;
            float v = (x - this.position.x) / (this.width / 120.0f);
            this.value = UISliderKt.access$clamp(v, 0.0f, 1.0f);
            this.f.invoke(Float.valueOf(this.value));
        }
        return false;
    }

    @Override
    public boolean touchDown(int screenX, int screenY, int pointer, int button) {
        if (this.hovered()) {
            float x = MouseKt.uiPointer().x;
            float v = (x - this.position.x) / (this.width / 120.0f);
            this.value = UISliderKt.access$clamp(v, 0.0f, 1.0f);
            Log.INSTANCE.debug(Intrinsics.stringPlus("Slider value start: ", Float.valueOf(this.value)));
            this.f.invoke(Float.valueOf(this.value));
            this.dragging = true;
        }
        return false;
    }

    @Override
    public boolean touchUp(int screenX, int screenY, int pointer, int button) {
        if (this.dragging) {
            Log.INSTANCE.debug(Intrinsics.stringPlus("Slider value end: ", Float.valueOf(this.value)));
            this.f.invoke(Float.valueOf(this.value));
        }
        this.dragging = false;
        return false;
    }

    public final float component1() {
        return this.value;
    }

    @NotNull
    public final Vector2 component2() {
        return this.position;
    }

    public final float component3() {
        return this.scale;
    }

    @NotNull
    public final Function1<Float, Unit> component4() {
        return this.f;
    }

    @NotNull
    public final UISlider copy(float value, @NotNull Vector2 position, float scale, @NotNull Function1<? super Float, Unit> f) {
        Intrinsics.checkNotNullParameter(position, "position");
        Intrinsics.checkNotNullParameter(f, "f");
        return new UISlider(value, position, scale, f);
    }

    public static /* synthetic */ UISlider copy$default(UISlider uISlider, float f, Vector2 vector2, float f2, Function1 function1, int n, Object object) {
        if ((n & 1) != 0) {
            f = uISlider.value;
        }
        if ((n & 2) != 0) {
            vector2 = uISlider.position;
        }
        if ((n & 4) != 0) {
            f2 = uISlider.scale;
        }
        if ((n & 8) != 0) {
            function1 = uISlider.f;
        }
        return uISlider.copy(f, vector2, f2, function1);
    }

    @NotNull
    public String toString() {
        return "UISlider(value=" + this.value + ", position=" + this.position + ", scale=" + this.scale + ", f=" + this.f + ')';
    }

    public int hashCode() {
        int result2 = Float.hashCode(this.value);
        result2 = result2 * 31 + this.position.hashCode();
        result2 = result2 * 31 + Float.hashCode(this.scale);
        result2 = result2 * 31 + this.f.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof UISlider)) {
            return false;
        }
        UISlider uISlider = (UISlider)other;
        if (!Intrinsics.areEqual((Object)Float.valueOf(this.value), (Object)Float.valueOf(uISlider.value))) {
            return false;
        }
        if (!Intrinsics.areEqual(this.position, uISlider.position)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)Float.valueOf(this.scale), (Object)Float.valueOf(uISlider.scale))) {
            return false;
        }
        return Intrinsics.areEqual(this.f, uISlider.f);
    }

    static {
        Sound sound;
        TextureRegion textureRegion;
        TextureRegion textureRegion2;
        TextureRegion textureRegion3;
        TextureRegion textureRegion4;
        BitmapFont bitmapFont;
        AssetManager this_$iv;
        Companion = new Companion(null);
        AssetManager assetManager = PPresentationKt.getAm();
        AssetRef assetRef$iv = Asset.Font.INSTANCE.getJbr20();
        boolean $i$f$get = false;
        try {
            Object object = this_$iv.getAssets().get(assetRef$iv);
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.badlogic.gdx.graphics.g2d.BitmapFont");
            }
            bitmapFont = (BitmapFont)object;
        }
        catch (Exception ex$iv) {
            Log.INSTANCE.critical("AssetRef " + assetRef$iv + " not loaded");
            throw ex$iv;
        }
        font = bitmapFont;
        this_$iv = PPresentationKt.getAm();
        assetRef$iv = Asset.UI.INSTANCE.getSliderBar();
        $i$f$get = false;
        try {
            Object object = this_$iv.getAssets().get(assetRef$iv);
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.badlogic.gdx.graphics.g2d.TextureRegion");
            }
            textureRegion4 = (TextureRegion)object;
        }
        catch (Exception ex$iv) {
            Log.INSTANCE.critical("AssetRef " + assetRef$iv + " not loaded");
            throw ex$iv;
        }
        usedBar = textureRegion4;
        this_$iv = PPresentationKt.getAm();
        assetRef$iv = Asset.UI.INSTANCE.getSliderBarDark();
        $i$f$get = false;
        try {
            Object object = this_$iv.getAssets().get(assetRef$iv);
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.badlogic.gdx.graphics.g2d.TextureRegion");
            }
            textureRegion3 = (TextureRegion)object;
        }
        catch (Exception ex$iv) {
            Log.INSTANCE.critical("AssetRef " + assetRef$iv + " not loaded");
            throw ex$iv;
        }
        unusedBar = textureRegion3;
        this_$iv = PPresentationKt.getAm();
        assetRef$iv = Asset.UI.INSTANCE.getSliderHandle();
        $i$f$get = false;
        try {
            Object object = this_$iv.getAssets().get(assetRef$iv);
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.badlogic.gdx.graphics.g2d.TextureRegion");
            }
            textureRegion2 = (TextureRegion)object;
        }
        catch (Exception ex$iv) {
            Log.INSTANCE.critical("AssetRef " + assetRef$iv + " not loaded");
            throw ex$iv;
        }
        handle = textureRegion2;
        this_$iv = PPresentationKt.getAm();
        assetRef$iv = Asset.UI.INSTANCE.getSliderHandleHovered();
        $i$f$get = false;
        try {
            Object object = this_$iv.getAssets().get(assetRef$iv);
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.badlogic.gdx.graphics.g2d.TextureRegion");
            }
            textureRegion = (TextureRegion)object;
        }
        catch (Exception ex$iv) {
            Log.INSTANCE.critical("AssetRef " + assetRef$iv + " not loaded");
            throw ex$iv;
        }
        handleHovered = textureRegion;
        this_$iv = PPresentationKt.getAm();
        assetRef$iv = Asset.Sound.INSTANCE.getHover();
        $i$f$get = false;
        try {
            Object object = this_$iv.getAssets().get(assetRef$iv);
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.badlogic.gdx.audio.Sound");
            }
            sound = (Sound)object;
        }
        catch (Exception ex$iv) {
            Log.INSTANCE.critical("AssetRef " + assetRef$iv + " not loaded");
            throw ex$iv;
        }
        hoverSound = sound;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\nR\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\nR\u0011\u0010\u0013\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\n\u00a8\u0006\u0015"}, d2={"Lorg/veiset/kgame/engine/ui/component/UISlider$Companion;", "", "()V", "font", "Lcom/badlogic/gdx/graphics/g2d/BitmapFont;", "getFont", "()Lcom/badlogic/gdx/graphics/g2d/BitmapFont;", "handle", "Lcom/badlogic/gdx/graphics/g2d/TextureRegion;", "getHandle", "()Lcom/badlogic/gdx/graphics/g2d/TextureRegion;", "handleHovered", "getHandleHovered", "hoverSound", "Lcom/badlogic/gdx/audio/Sound;", "getHoverSound", "()Lcom/badlogic/gdx/audio/Sound;", "unusedBar", "getUnusedBar", "usedBar", "getUsedBar", "kgame2"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final BitmapFont getFont() {
            return font;
        }

        @NotNull
        public final TextureRegion getUsedBar() {
            return usedBar;
        }

        @NotNull
        public final TextureRegion getUnusedBar() {
            return unusedBar;
        }

        @NotNull
        public final TextureRegion getHandle() {
            return handle;
        }

        @NotNull
        public final TextureRegion getHandleHovered() {
            return handleHovered;
        }

        @NotNull
        public final Sound getHoverSound() {
            return hoverSound;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

