/*
 * Decompiled with CFR 0.152.
 */
package org.veiset.kgame.engine.world;

import com.badlogic.gdx.math.Vector2;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.veiset.kgame.engine.math.Vector2Kt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0015\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\tJ\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0003H\u00c6\u0003JE\u0010\u0017\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u00032\b\b\u0002\u0010\u0007\u001a\u00020\u00032\b\b\u0002\u0010\b\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001b\u001a\u00020\u001cH\u00d6\u0001J\u000e\u0010\u001d\u001a\u00020\u00192\u0006\u0010\u001e\u001a\u00020\u001fJ\u0018\u0010 \u001a\u00020\u001f2\u0006\u0010\u001e\u001a\u00020\u001f2\b\b\u0002\u0010!\u001a\u00020\u0003J\u000e\u0010\"\u001a\u00020\u00192\u0006\u0010\u001e\u001a\u00020\u001fJ\t\u0010#\u001a\u00020$H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000bR\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000bR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000bR\u0011\u0010\b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000b\u00a8\u0006%"}, d2={"Lorg/veiset/kgame/engine/world/WorldMapBounds;", "", "mapX", "", "mapY", "x0", "y0", "x1", "y1", "(FFFFFF)V", "getMapX", "()F", "getMapY", "getX0", "getX1", "getY0", "getY1", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "equals", "", "other", "hashCode", "", "isOnBound", "pos", "Lcom/badlogic/gdx/math/Vector2;", "keepBound", "cameraScale", "outsideBound", "toString", "", "kgame2"})
public final class WorldMapBounds {
    private final float mapX;
    private final float mapY;
    private final float x0;
    private final float y0;
    private final float x1;
    private final float y1;

    public WorldMapBounds(float mapX, float mapY, float x0, float y0, float x1, float y1) {
        this.mapX = mapX;
        this.mapY = mapY;
        this.x0 = x0;
        this.y0 = y0;
        this.x1 = x1;
        this.y1 = y1;
    }

    public final float getMapX() {
        return this.mapX;
    }

    public final float getMapY() {
        return this.mapY;
    }

    public final float getX0() {
        return this.x0;
    }

    public final float getY0() {
        return this.y0;
    }

    public final float getX1() {
        return this.x1;
    }

    public final float getY1() {
        return this.y1;
    }

    public final boolean outsideBound(@NotNull Vector2 pos) {
        Intrinsics.checkNotNullParameter(pos, "pos");
        float x = Vector2Kt.component1(pos);
        float y = Vector2Kt.component2(pos);
        return x < this.x0 || x > this.x1 || y < this.y0 || y > this.y1;
    }

    public final boolean isOnBound(@NotNull Vector2 pos) {
        Intrinsics.checkNotNullParameter(pos, "pos");
        float x = Vector2Kt.component1(pos);
        float y = Vector2Kt.component2(pos);
        return x == this.x0 || x == this.x1 || y == this.y0 || y == this.y1;
    }

    @NotNull
    public final Vector2 keepBound(@NotNull Vector2 pos, float cameraScale) {
        Intrinsics.checkNotNullParameter(pos, "pos");
        float x = Vector2Kt.component1(pos);
        float y = Vector2Kt.component2(pos);
        float f = this.x0 * cameraScale;
        f = Math.max(x, f);
        float f2 = this.x1;
        float f3 = Math.min(f, f2);
        f = this.y0 * cameraScale;
        f = Math.max(y, f);
        f2 = this.y1;
        return Vector2Kt.x(f3, Math.min(f, f2));
    }

    public static /* synthetic */ Vector2 keepBound$default(WorldMapBounds worldMapBounds, Vector2 vector2, float f, int n, Object object) {
        if ((n & 2) != 0) {
            f = 1.0f;
        }
        return worldMapBounds.keepBound(vector2, f);
    }

    public final float component1() {
        return this.mapX;
    }

    public final float component2() {
        return this.mapY;
    }

    public final float component3() {
        return this.x0;
    }

    public final float component4() {
        return this.y0;
    }

    public final float component5() {
        return this.x1;
    }

    public final float component6() {
        return this.y1;
    }

    @NotNull
    public final WorldMapBounds copy(float mapX, float mapY, float x0, float y0, float x1, float y1) {
        return new WorldMapBounds(mapX, mapY, x0, y0, x1, y1);
    }

    public static /* synthetic */ WorldMapBounds copy$default(WorldMapBounds worldMapBounds, float f, float f2, float f3, float f4, float f5, float f6, int n, Object object) {
        if ((n & 1) != 0) {
            f = worldMapBounds.mapX;
        }
        if ((n & 2) != 0) {
            f2 = worldMapBounds.mapY;
        }
        if ((n & 4) != 0) {
            f3 = worldMapBounds.x0;
        }
        if ((n & 8) != 0) {
            f4 = worldMapBounds.y0;
        }
        if ((n & 0x10) != 0) {
            f5 = worldMapBounds.x1;
        }
        if ((n & 0x20) != 0) {
            f6 = worldMapBounds.y1;
        }
        return worldMapBounds.copy(f, f2, f3, f4, f5, f6);
    }

    @NotNull
    public String toString() {
        return "WorldMapBounds(mapX=" + this.mapX + ", mapY=" + this.mapY + ", x0=" + this.x0 + ", y0=" + this.y0 + ", x1=" + this.x1 + ", y1=" + this.y1 + ')';
    }

    public int hashCode() {
        int result2 = Float.hashCode(this.mapX);
        result2 = result2 * 31 + Float.hashCode(this.mapY);
        result2 = result2 * 31 + Float.hashCode(this.x0);
        result2 = result2 * 31 + Float.hashCode(this.y0);
        result2 = result2 * 31 + Float.hashCode(this.x1);
        result2 = result2 * 31 + Float.hashCode(this.y1);
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof WorldMapBounds)) {
            return false;
        }
        WorldMapBounds worldMapBounds = (WorldMapBounds)other;
        if (!Intrinsics.areEqual((Object)Float.valueOf(this.mapX), (Object)Float.valueOf(worldMapBounds.mapX))) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)Float.valueOf(this.mapY), (Object)Float.valueOf(worldMapBounds.mapY))) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)Float.valueOf(this.x0), (Object)Float.valueOf(worldMapBounds.x0))) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)Float.valueOf(this.y0), (Object)Float.valueOf(worldMapBounds.y0))) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)Float.valueOf(this.x1), (Object)Float.valueOf(worldMapBounds.x1))) {
            return false;
        }
        return Intrinsics.areEqual((Object)Float.valueOf(this.y1), (Object)Float.valueOf(worldMapBounds.y1));
    }
}

