/*
 * Decompiled with CFR 0.152.
 */
package org.veiset.kgame.module;

import com.badlogic.ashley.core.Engine;
import com.badlogic.ashley.core.Entity;
import com.badlogic.ashley.core.EntityListener;
import com.badlogic.ashley.core.EntitySystem;
import com.badlogic.ashley.core.Family;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.audio.Music;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.physics.box2d.World;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import ktx.box2d.WorldsKt;
import org.jetbrains.annotations.NotNull;
import org.veiset.kgame.engine.EngineConfig;
import org.veiset.kgame.engine.GameFilesKt;
import org.veiset.kgame.engine.GameModule;
import org.veiset.kgame.engine.Log;
import org.veiset.kgame.engine.LoggerKt;
import org.veiset.kgame.engine.TBEngineKt;
import org.veiset.kgame.engine.asset.AssetManager;
import org.veiset.kgame.engine.asset.AssetRef;
import org.veiset.kgame.engine.ecs.attack.component.AttackType;
import org.veiset.kgame.engine.ecs.attack.system.ProjectileAttackSystem;
import org.veiset.kgame.engine.ecs.collision.system.AreaCollisionResolveSystem;
import org.veiset.kgame.engine.ecs.collision.system.AttackCollisionResolveSystem;
import org.veiset.kgame.engine.ecs.collision.system.Box2dSystem;
import org.veiset.kgame.engine.ecs.collision.system.SensorCollisionResolveSystem;
import org.veiset.kgame.engine.ecs.core.component.enemy.MonsterComponent;
import org.veiset.kgame.engine.ecs.core.component.loot.LootTableComponent;
import org.veiset.kgame.engine.ecs.core.entity.ItemDropEntity;
import org.veiset.kgame.engine.ecs.core.entity.PauseEntity;
import org.veiset.kgame.engine.ecs.core.entity.PlayerEntity;
import org.veiset.kgame.engine.ecs.core.system.DeathSystem;
import org.veiset.kgame.engine.ecs.core.system.DelayAddEntitySystem;
import org.veiset.kgame.engine.ecs.core.system.FixedDurationSystem;
import org.veiset.kgame.engine.ecs.core.system.GamePauseSystem;
import org.veiset.kgame.engine.ecs.core.system.MoveGfxToTargetSystem;
import org.veiset.kgame.engine.ecs.core.system.ai.AStarPathfindingSystem;
import org.veiset.kgame.engine.ecs.core.system.ai.LinearMovementAISystem;
import org.veiset.kgame.engine.ecs.core.system.attack.AttackPlayerSystem;
import org.veiset.kgame.engine.ecs.core.system.attack.PlayerAttackSystem;
import org.veiset.kgame.engine.ecs.core.system.debug.CameraDebugSystem;
import org.veiset.kgame.engine.ecs.core.system.debug.CheatSystem;
import org.veiset.kgame.engine.ecs.core.system.debug.ControllerSchemeSystem;
import org.veiset.kgame.engine.ecs.core.system.debug.DebugControlSystem;
import org.veiset.kgame.engine.ecs.core.system.debug.EngineSpeedSystem;
import org.veiset.kgame.engine.ecs.core.system.debug.ProfilerSystem;
import org.veiset.kgame.engine.ecs.core.system.debug.ProfilerSystemKt;
import org.veiset.kgame.engine.ecs.core.system.enemy.BossHealthBarSystem;
import org.veiset.kgame.engine.ecs.core.system.enemy.EnemyRemindingSystem;
import org.veiset.kgame.engine.ecs.core.system.enemy.EnemySpawnSystem;
import org.veiset.kgame.engine.ecs.core.system.enemy.PointToEnemySystem;
import org.veiset.kgame.engine.ecs.core.system.graphics.AnimationSystem;
import org.veiset.kgame.engine.ecs.core.system.graphics.BackgroundTilesSystem;
import org.veiset.kgame.engine.ecs.core.system.graphics.CameraSystem;
import org.veiset.kgame.engine.ecs.core.system.graphics.DrawSystem;
import org.veiset.kgame.engine.ecs.core.system.graphics.DynamicShadowSystem;
import org.veiset.kgame.engine.ecs.core.system.graphics.LightSystem;
import org.veiset.kgame.engine.ecs.core.system.graphics.ShadowSystem;
import org.veiset.kgame.engine.ecs.core.system.graphics.UpdateAnimationStateSystem;
import org.veiset.kgame.engine.ecs.core.system.graphics.effect.WeatherSystem;
import org.veiset.kgame.engine.ecs.core.system.loot.AutoPickupLootSystem;
import org.veiset.kgame.engine.ecs.core.system.loot.BlindSystem;
import org.veiset.kgame.engine.ecs.core.system.loot.ItemSpawnLocationSystem;
import org.veiset.kgame.engine.ecs.core.system.loot.PickupLootSystem;
import org.veiset.kgame.engine.ecs.core.system.physics.VelocityPositionSystem;
import org.veiset.kgame.engine.ecs.core.system.player.InventorySystem;
import org.veiset.kgame.engine.ecs.core.system.player.PlayerInputSystem;
import org.veiset.kgame.engine.ecs.core.system.player.PlayerPositionBoundSystem;
import org.veiset.kgame.engine.ecs.core.system.scenario.ScenarioBossSystem;
import org.veiset.kgame.engine.ecs.core.system.ui.DrawUiGfxSystem;
import org.veiset.kgame.engine.ecs.modifier.AddModifierSystem;
import org.veiset.kgame.engine.ecs.modifier.DisplayPlayerModifiersSystem;
import org.veiset.kgame.engine.ecs.modifier.ModifiersComponent;
import org.veiset.kgame.engine.ecs.modifier.ModifiersComponentMonsterEvent;
import org.veiset.kgame.engine.ecs.sound.system.SoundSystem;
import org.veiset.kgame.engine.item.Boots;
import org.veiset.kgame.engine.item.Equipment;
import org.veiset.kgame.engine.item.Loot;
import org.veiset.kgame.engine.item.LootTable;
import org.veiset.kgame.engine.item.LootTablesKt;
import org.veiset.kgame.engine.item.SimpleLootSystem;
import org.veiset.kgame.engine.item.Weapon;
import org.veiset.kgame.engine.math.Vector2Kt;
import org.veiset.kgame.engine.modifier.BaseAttack;
import org.veiset.kgame.engine.modifier.Modifier;
import org.veiset.kgame.engine.modifier.ModifierTiersKt;
import org.veiset.kgame.engine.modifier.RandomItemGenerator;
import org.veiset.kgame.engine.state.GameLevelState;
import org.veiset.kgame.engine.ui.SettingsUI;
import org.veiset.kgame.engine.values.Asset;
import org.veiset.kgame.engine.values.ProfilerName;
import org.veiset.kgame.engine.world.WorldMap;
import org.veiset.kgame.engine.world.WorldMapBounds;
import org.veiset.kgame.engine.world.WorldMapKt;
import org.veiset.kgame.game.GameState;
import org.veiset.kgame.module.GameSummaryModule;
import org.veiset.kgame.module.GameWorldModuleKt;
import org.veiset.kgame.module.LevelSelectModule;
import org.veiset.kgame.module.transition.FadeModuleLoader;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0000\u0018\u00002\u00020\u0001B#\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0006\u0010\u0017\u001a\u00020\u0018J\b\u0010\u0019\u001a\u00020\u0018H\u0002J\b\u0010\u001a\u001a\u00020\u0001H\u0016J\b\u0010\u001b\u001a\u00020\u0018H\u0016J\u0010\u0010\u001c\u001a\u00020\u00182\u0006\u0010\u001d\u001a\u00020\u001eH\u0016R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lorg/veiset/kgame/module/GameWorldModule;", "Lorg/veiset/kgame/engine/GameModule;", "engine", "Lcom/badlogic/ashley/core/Engine;", "world", "Lcom/badlogic/gdx/physics/box2d/World;", "gameLevelState", "Lorg/veiset/kgame/engine/state/GameLevelState;", "(Lcom/badlogic/ashley/core/Engine;Lcom/badlogic/gdx/physics/box2d/World;Lorg/veiset/kgame/engine/state/GameLevelState;)V", "am", "Lorg/veiset/kgame/engine/asset/AssetManager;", "enemyRemindingSystem", "Lorg/veiset/kgame/engine/ecs/core/system/enemy/EnemyRemindingSystem;", "getEngine", "()Lcom/badlogic/ashley/core/Engine;", "gameState", "Lorg/veiset/kgame/game/GameState;", "playerEntity", "Lorg/veiset/kgame/engine/ecs/core/entity/PlayerEntity;", "getPlayerEntity", "()Lorg/veiset/kgame/engine/ecs/core/entity/PlayerEntity;", "settingsUI", "Lorg/veiset/kgame/engine/ui/SettingsUI;", "addEntities", "", "addEventListeners", "nextState", "teardown", "update", "delta", "", "kgame2"})
public final class GameWorldModule
extends GameModule {
    @NotNull
    private final Engine engine;
    @NotNull
    private final World world;
    @NotNull
    private final GameLevelState gameLevelState;
    @NotNull
    private final AssetManager am;
    @NotNull
    private final GameState gameState;
    @NotNull
    private final SettingsUI settingsUI;
    @NotNull
    private final EnemyRemindingSystem enemyRemindingSystem;
    @NotNull
    private final PlayerEntity playerEntity;

    /*
     * WARNING - void declaration
     */
    public GameWorldModule(@NotNull Engine engine, @NotNull World world, @NotNull GameLevelState gameLevelState) {
        Music music;
        Intrinsics.checkNotNullParameter(engine, "engine");
        Intrinsics.checkNotNullParameter(world, "world");
        Intrinsics.checkNotNullParameter(gameLevelState, "gameLevelState");
        this.engine = engine;
        this.world = world;
        this.gameLevelState = gameLevelState;
        this.am = TBEngineKt.getGlobals().getAssetManager();
        this.gameState = TBEngineKt.getGlobals().getState();
        this.settingsUI = new SettingsUI(false, false, 3, null);
        this.enemyRemindingSystem = new EnemyRemindingSystem();
        this.gameState.setProceedToMapSelect(false);
        this.gameState.setProceedToSummary(false);
        Object object = TBEngineKt.getGlobals().getAssetManager();
        AssetRef assetRef$iv = Asset.Music.INSTANCE.getMain();
        boolean $i$f$get = false;
        try {
            void this_$iv;
            Object object2 = this_$iv.getAssets().get(assetRef$iv);
            if (object2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.badlogic.gdx.audio.Music");
            }
            music = (Music)object2;
        }
        catch (Exception ex$iv) {
            Log.INSTANCE.critical("AssetRef " + assetRef$iv + " not loaded");
            throw ex$iv;
        }
        Music it = music;
        boolean bl = false;
        it.play();
        it.setVolume(GameFilesKt.getGameConfig().getVolumeMusic() * GameFilesKt.getGameConfig().getVolumeMaster());
        this.gameLevelState.getSelectedLevel().getArea();
        TBEngineKt.getGlobals().getDrawGfx().getCamera().zoom = 1.0f;
        Log.INSTANCE.info(Intrinsics.stringPlus("Engine entities at start: ", this.getEngine().getEntities().size()));
        final WorldMap worldMap2 = (WorldMap)LoggerKt.logTimed$default("generating world", null, null, 0, new Function0<WorldMap>(this){
            final /* synthetic */ GameWorldModule this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final WorldMap invoke() {
                return new WorldMap(GameWorldModule.access$getGameLevelState$p(this.this$0).getSelectedLevel().getArea(), 3.0f, 0L, 4, null);
            }
        }, 14, null);
        LoggerKt.logTimed$default("Populating game world with asset groups", null, null, 0, new Function0<Unit>(){

            @Override
            public final void invoke() {
                GameWorldModuleKt.populateGameWorld(this.getEngine(), world, worldMap2);
            }
        }, 14, null);
        if (EngineConfig.Debug.INSTANCE.getZOOM_OUT_DEBUG()) {
            TBEngineKt.getGlobals().getDrawGfx().getCamera().zoom = EngineConfig.Debug.INSTANCE.getDEBUG_CAMERA_ZOOM();
        }
        EngineConfig.Game.INSTANCE.setPlayerStartPos(Vector2Kt.x(3.0f, 3.0f));
        Object gamePauseSystem = new GamePauseSystem();
        WorldMapBounds worldMapBounds = WorldMapKt.bounds(this.gameLevelState.getSelectedLevel().getArea());
        Log.INSTANCE.info("Adding event listeners");
        this.addEventListeners();
        Log.INSTANCE.info("Done adding listeners");
        this.getEngine().addSystem((EntitySystem)gamePauseSystem);
        this.getEngine().addSystem(new Box2dSystem(this.world));
        this.getEngine().addSystem(new SensorCollisionResolveSystem());
        this.getEngine().addSystem(new AttackCollisionResolveSystem(this.world));
        this.getEngine().addSystem(new AreaCollisionResolveSystem(this.world));
        this.getEngine().addSystem(new FixedDurationSystem());
        this.getEngine().addSystem(new DelayAddEntitySystem());
        this.getEngine().addSystem(new BackgroundTilesSystem(worldMap2));
        this.getEngine().addSystem(new ShadowSystem(this.world));
        this.getEngine().addSystem(new DrawSystem((GamePauseSystem)gamePauseSystem));
        this.getEngine().addSystem(new VelocityPositionSystem());
        this.getEngine().addSystem(new DeathSystem(this.world));
        this.getEngine().addSystem(new CameraSystem(EngineConfig.Game.INSTANCE.getPlayerStartPos(), worldMapBounds));
        this.getEngine().addSystem(new AnimationSystem());
        this.getEngine().addSystem(new DynamicShadowSystem());
        this.getEngine().addSystem(new UpdateAnimationStateSystem());
        this.getEngine().addSystem(new WeatherSystem());
        this.getEngine().addSystem(new LightSystem(this.world));
        this.getEngine().addSystem(new EnemySpawnSystem(this.world, this.gameLevelState.getSelectedLevel(), worldMapBounds));
        this.getEngine().addSystem(new BlindSystem());
        this.getEngine().addSystem(new ScenarioBossSystem(worldMapBounds));
        this.getEngine().addSystem(new LinearMovementAISystem());
        this.getEngine().addSystem(new AStarPathfindingSystem(this.world, this.gameLevelState.getSelectedLevel().getArea().getAreaSize(), null, null, 12, null));
        this.getEngine().addSystem(new InventorySystem());
        this.getEngine().addSystem(new AutoPickupLootSystem());
        this.getEngine().addSystem(new PickupLootSystem());
        this.getEngine().addSystem(new ItemSpawnLocationSystem());
        this.getEngine().addSystem(new PlayerPositionBoundSystem(worldMapBounds));
        this.getEngine().addSystem(new PointToEnemySystem());
        this.getEngine().addSystem(new BossHealthBarSystem());
        this.getEngine().addSystem(this.enemyRemindingSystem);
        this.getEngine().addSystem(new AttackPlayerSystem(this.world));
        this.getEngine().addSystem(new PlayerAttackSystem(this.world));
        this.getEngine().addSystem(new ProjectileAttackSystem());
        this.getEngine().addSystem(new SoundSystem());
        this.getEngine().addSystem(new MoveGfxToTargetSystem());
        this.getEngine().addSystem(new DisplayPlayerModifiersSystem());
        this.getEngine().addSystem(new DrawUiGfxSystem());
        this.getEngine().addSystem(new CameraDebugSystem());
        this.getEngine().addSystem(new DebugControlSystem(this.world));
        this.getEngine().addSystem(new ProfilerSystem());
        this.getEngine().addSystem(new EngineSpeedSystem());
        this.getEngine().addSystem(new CheatSystem());
        this.getEngine().addSystem(new ControllerSchemeSystem());
        this.getEngine().addSystem(new PlayerInputSystem(this.world));
        Log.INSTANCE.debug("GameWorldModule Systems loaded");
        this.addEntities();
        Log.INSTANCE.debug("GameWorldModule Entities added");
        Log.INSTANCE.info(Intrinsics.stringPlus("Engine entities after systems added: ", this.getEngine().getEntities().size()));
        gamePauseSystem = object = new PlayerEntity(this.world, EngineConfig.Game.INSTANCE.getPlayerStartPos(), this.getEngine(), this.gameState.getInventory());
        GameWorldModule gameWorldModule = this;
        boolean bl2 = false;
        this.getEngine().addEntity((Entity)((Object)it));
        gameWorldModule.playerEntity = object;
    }

    public /* synthetic */ GameWorldModule(Engine engine, World world, GameLevelState gameLevelState, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            engine = new Engine();
        }
        if ((n & 2) != 0) {
            World world2;
            World it = world2 = WorldsKt.createWorld$default(null, false, 3, null);
            boolean bl = false;
            Log.INSTANCE.debug("GameWorldModule Loaded World");
            world = world2;
        }
        if ((n & 4) != 0) {
            gameLevelState = new GameLevelState(null, null, null, null, 15, null);
        }
        this(engine, world, gameLevelState);
    }

    @Override
    @NotNull
    public Engine getEngine() {
        return this.engine;
    }

    @NotNull
    public final PlayerEntity getPlayerEntity() {
        return this.playerEntity;
    }

    private final void addEventListeners() {
        Class[] classArray = new Class[]{ModifiersComponent.class, MonsterComponent.class};
        this.getEngine().addEntityListener(Family.all(classArray).get(), (EntityListener)new ModifiersComponentMonsterEvent());
    }

    @Override
    public void teardown() {
        this.getEngine().removeAllEntities();
    }

    public final void addEntities() {
        List<Loot<Equipment>> drops = new LootTableComponent(new LootTable(new SimpleLootSystem(1.0f, 1.0f, 3), LootTablesKt.getBigTable())).getLootTable().generateItems();
        Iterable $this$forEach$iv = drops;
        boolean $i$f$forEach22 = false;
        for (Object element$iv : $this$forEach$iv) {
            Loot loot = (Loot)element$iv;
            boolean bl = false;
        }
        Modifier[] $i$f$forEach22 = new Modifier[]{new Modifier.Attack.AdditionalProjectile(4), new Modifier.Attack.Duration(4.0f), new Modifier.Attack.Chain(1), new Modifier.Attack.Homing(), new Modifier.Attack.CriticalChance(0.9f), new Modifier.Damage.Flat(10.0f), new Modifier.Attack.AttackSpeed(1.5f)};
        Weapon debugWeapon = new Weapon(Asset.Icon.Weapon.INSTANCE.getWeapon05(), "Debug Weapon #1", new BaseAttack(AttackType.Projectile.INSTANCE, 20.0f, 0.1f, 1.0f, 0.0f, CollectionsKt.listOf($i$f$forEach22), 16, null));
        Object[] objectArray = new Object[]{new Modifier.Attack.AdditionalProjectile(102), new Modifier.Attack.Duration(2.0f), new Modifier.Attack.CriticalChance(0.5f), new Modifier.Attack.Spread(3.0f)};
        Weapon debugWeapon2 = new Weapon(Asset.Icon.Weapon.INSTANCE.getWeapon10(), "Debug Weapon #2", new BaseAttack(AttackType.Projectile.INSTANCE, 50.0f, 0.1f, 1.5f, 0.0f, CollectionsKt.listOf(objectArray), 16, null));
        Boots debugBoots = new Boots(Asset.Icon.Boot.INSTANCE.getOfSpeed(), "Speedy Boots", CollectionsKt.listOf(new Modifier.Speed.Increase(1.0f)));
        if (GameFilesKt.getGameConfig().getSpawnDebugItems()) {
            this.getEngine().addEntity(new ItemDropEntity(debugWeapon2, Vector2Kt.plus(Vector2Kt.copy(EngineConfig.Game.INSTANCE.getPlayerStartPos()), new Vector2(-1.0f, 1.0f))));
            this.getEngine().addEntity(new ItemDropEntity(debugWeapon, Vector2Kt.plus(Vector2Kt.copy(EngineConfig.Game.INSTANCE.getPlayerStartPos()), new Vector2(0.0f, 1.0f))));
            this.getEngine().addEntity(new ItemDropEntity(new RandomItemGenerator(ModifierTiersKt.getWeaponModifiers()).generateWeapon(), Vector2Kt.plus(Vector2Kt.copy(EngineConfig.Game.INSTANCE.getPlayerStartPos()), new Vector2(1.0f, 1.0f))));
            this.getEngine().addEntity(new ItemDropEntity(debugBoots, Vector2Kt.plus(Vector2Kt.copy(EngineConfig.Game.INSTANCE.getPlayerStartPos()), new Vector2(-1.0f, 0.0f))));
        }
    }

    @Override
    public void update(float delta) {
        ProfilerSystemKt.profile(this.getEngine(), ProfilerName.GLOBAL, (Function0)new Function0<Unit>(this, delta){
            final /* synthetic */ GameWorldModule this$0;
            final /* synthetic */ float $delta;
            {
                this.this$0 = $receiver;
                this.$delta = $delta;
                super(0);
            }

            /*
             * Unable to fully structure code
             */
            public final void invoke() {
                this.this$0.getEngine().update(this.$delta);
                if (GameWorldModule.access$getSettingsUI$p(this.this$0).getActive()) {
                    GameWorldModule.access$getSettingsUI$p(this.this$0).draw(this.$delta);
                }
                if (!TBEngineKt.getGlobals().getKeyMapper().cancel()) ** GOTO lbl-1000
                var1_1 = this.this$0.getEngine().getSystems();
                Intrinsics.checkNotNullExpressionValue(var1_1, "engine.systems");
                $this$filterIsInstance$iv = var1_1;
                $i$f$filterIsInstance = false;
                var3_3 = $this$filterIsInstance$iv;
                destination$iv$iv = new ArrayList<E>();
                $i$f$filterIsInstanceTo = false;
                for (T element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                    if (!(element$iv$iv instanceof AddModifierSystem)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                if (((List)destination$iv$iv).isEmpty()) {
                    if (GameWorldModule.access$getSettingsUI$p(this.this$0).getActive()) {
                        this.this$0.getEngine().addEntity(new PauseEntity(false, false, 0.0f, 6, null));
                        GameWorldModule.access$getSettingsUI$p(this.this$0).close();
                    } else {
                        this.this$0.getEngine().addEntity(new PauseEntity(true, true, 0.0f, 4, null));
                        GameWorldModule.access$getSettingsUI$p(this.this$0).open();
                    }
                } else if (GameWorldModule.access$getSettingsUI$p(this.this$0).getConfirmed()) {
                    this.this$0.getEngine().addEntity(new PauseEntity(false, false, 0.0f, 6, null));
                    GameWorldModule.access$getSettingsUI$p(this.this$0).close();
                }
                if (Gdx.input.isKeyJustPressed(131)) {
                    this.this$0.getEngine().addSystem(new AddModifierSystem(null, 1, null));
                }
                if (GameWorldModule.access$getEnemyRemindingSystem$p(this.this$0).getRemindingMonsters() == 0 && !GameWorldModule.access$getEnemyRemindingSystem$p(this.this$0).getCleared()) {
                    GameWorldModule.access$getEnemyRemindingSystem$p(this.this$0).setCleared(true);
                    this.this$0.getEngine().addSystem(new AddModifierSystem(null, 1, null));
                }
            }
        });
    }

    @Override
    @NotNull
    public GameModule nextState() {
        if (TBEngineKt.getGlobals().getKeyMapper().selectMap()) {
            this.gameLevelState.getSelectedLevel().setFinished(true);
            return new FadeModuleLoader(this, 3.0f, null, new LevelSelectModule(new Engine(), this.gameLevelState), 4, null);
        }
        if (Gdx.input.isKeyJustPressed(46)) {
            TBEngineKt.getGlobals().setState(new GameState(0L, 0L, 0, false, false, 0, null, 127, null));
            return new GameWorldModule(new Engine(), null, this.gameLevelState, 2, null);
        }
        if (this.gameState.getProceedToMapSelect()) {
            return new FadeModuleLoader(this, 2.0f, null, new LevelSelectModule(new Engine(), this.gameLevelState), 4, null);
        }
        if (this.gameState.getProceedToSummary()) {
            return new FadeModuleLoader(this, 1.0f, null, new GameSummaryModule(new Engine()), 4, null);
        }
        return this;
    }

    public GameWorldModule() {
        this(null, null, null, 7, null);
    }

    public static final /* synthetic */ SettingsUI access$getSettingsUI$p(GameWorldModule $this) {
        return $this.settingsUI;
    }

    public static final /* synthetic */ EnemyRemindingSystem access$getEnemyRemindingSystem$p(GameWorldModule $this) {
        return $this.enemyRemindingSystem;
    }

    public static final /* synthetic */ GameLevelState access$getGameLevelState$p(GameWorldModule $this) {
        return $this.gameLevelState;
    }
}

